/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.mp_logger;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import net.sergeych.mp_logger.LogEntry;
import net.sergeych.sprintf.SprintfKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lnet/sergeych/mp_logger/LogFormatter;", "", "<init>", "()V", "startDelimiter", "", "getStartDelimiter", "()Ljava/lang/String;", "dateChangleDelimiter", "getDateChangleDelimiter", "tz", "Lkotlinx/datetime/TimeZone;", "getTz", "()Lkotlinx/datetime/TimeZone;", "value", "Lkotlinx/datetime/LocalDate;", "lastDate", "getLastDate", "()Lkotlinx/datetime/LocalDate;", "buffer", "", "getBuffer", "()Ljava/util/List;", "buffer$delegate", "Lkotlin/Lazy;", "formatEntry", "le", "Lnet/sergeych/mp_logger/LogEntry;", "format", "", "mp_stools"})
@SourceDebugExtension(value={"SMAP\nLogFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFormatter.kt\nnet/sergeych/mp_logger/LogFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public class LogFormatter {
    @NotNull
    private final String startDelimiter;
    @NotNull
    private final String dateChangleDelimiter;
    @NotNull
    private final TimeZone tz = TimeZone.Companion.currentSystemDefault();
    @Nullable
    private LocalDate lastDate;
    @NotNull
    private final Lazy buffer$delegate = LazyKt.lazy(() -> LogFormatter.buffer_delegate$lambda$0(this));

    public LogFormatter() {
        this.startDelimiter = "----------";
        this.dateChangleDelimiter = "---";
    }

    @NotNull
    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    @NotNull
    public String getDateChangleDelimiter() {
        return this.dateChangleDelimiter;
    }

    @NotNull
    protected TimeZone getTz() {
        return this.tz;
    }

    @Nullable
    protected final LocalDate getLastDate() {
        return this.lastDate;
    }

    @NotNull
    protected final List<String> getBuffer() {
        Lazy lazy = this.buffer$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected String formatEntry(@NotNull LogEntry le) {
        Intrinsics.checkNotNullParameter((Object)le, (String)"le");
        return le.toString();
    }

    @NotNull
    public List<String> format(@NotNull LogEntry le) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)le, (String)"le");
        LocalDate now = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)this.getTz()).getDate();
        if (this.lastDate == null) {
            this.lastDate = now;
        } else if (!Intrinsics.areEqual((Object)now, (Object)this.lastDate)) {
            objectArray = new Object[]{this.getDateChangleDelimiter(), now};
            this.getBuffer().add(SprintfKt.sprintf("%s Date changed: %s %1!s", objectArray));
            this.lastDate = now;
        }
        this.getBuffer().add(this.formatEntry(le));
        Object[] it = objectArray = CollectionsKt.toList((Iterable)this.getBuffer());
        boolean bl = false;
        this.getBuffer().clear();
        return objectArray;
    }

    private static final List buffer_delegate$lambda$0(LogFormatter this$0) {
        Object[] objectArray = new String[1];
        Object[] objectArray2 = new Object[]{this$0.getStartDelimiter(), Clock.System.INSTANCE.now()};
        objectArray[0] = SprintfKt.sprintf("%s log started: %tc %1!s", objectArray2);
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

