/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.mp_tools;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0002\u001a\n\u0010\t\u001a\u00020\u0005*\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\n\u0010\r\u001a\u00020\n*\u00020\u0005\u001a\n\u0010\u0010\u001a\u00020\n*\u00020\u0005\u001a\n\u0010\u0011\u001a\u00020\u0005*\u00020\n\u001a\n\u0010\u0012\u001a\u00020\u0005*\u00020\n\u001a\n\u0010\u0013\u001a\u00020\n*\u00020\u0005\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"base64codes", "", "", "[Ljava/lang/Integer;", "base64abc", "", "[Ljava/lang/String;", "getBase64Code", "charCode", "encodeToBase64", "", "removeAllSpaces", "src", "decodeBase64", "reSpaces", "Lkotlin/text/Regex;", "decodeBase64Compact", "encodeToBase64Compact", "encodeToBase64Url", "decodeBase64Url", "mp_stools"})
public final class Base64Kt {
    @NotNull
    private static final Integer[] base64codes;
    @NotNull
    private static final String[] base64abc;
    @NotNull
    private static final Regex reSpaces;

    private static final int getBase64Code(int charCode) {
        if (charCode >= base64codes.length) {
            throw new Exception("Unable to parse base64 string.");
        }
        int code = base64codes[charCode];
        if (code == 255) {
            throw new Exception("Unable to parse base64 string.");
        }
        return code;
    }

    @NotNull
    public static final String encodeToBase64(@NotNull byte[] $this$encodeToBase64) {
        int i;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToBase64, (String)"<this>");
        StringBuilder result = new StringBuilder();
        int l = $this$encodeToBase64.length;
        for (i = 2; i < l; i += 3) {
            result.append(base64abc[Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 2) >> 2]);
            result.append(base64abc[(Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 2) & 3) << 4 | Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 1) >> 4]);
            result.append(base64abc[(Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 1) & 0xF) << 2 | Base64Kt.encodeToBase64$b($this$encodeToBase64, i) >> 6]);
            result.append(base64abc[Base64Kt.encodeToBase64$b($this$encodeToBase64, i) & 0x3F]);
        }
        if (i == l + 1) {
            result.append(base64abc[Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 2) >> 2]);
            result.append(base64abc[(Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 2) & 3) << 4]);
            result.append("==");
        }
        if (i == l) {
            result.append(base64abc[Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 2) >> 2]);
            result.append(base64abc[(Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 2) & 3) << 4 | Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 1) >> 4]);
            result.append(base64abc[(Base64Kt.encodeToBase64$b($this$encodeToBase64, i - 1) & 0xF) << 2]);
            result.append("=");
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String removeAllSpaces(String src) {
        StringBuilder result = new StringBuilder();
        int n = src.length();
        block3: for (int i = 0; i < n; ++i) {
            char ch = src.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull String $this$decodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
        String str = Base64Kt.removeAllSpaces($this$decodeBase64);
        if (str.length() % 4 != 0) {
            throw new IllegalArgumentException("Unable to parse base64 string: wrong size");
        }
        int index = StringsKt.indexOf$default((CharSequence)str, (String)"=", (int)0, (boolean)false, (int)6, null);
        if (index != -1 && index < str.length() - 2) {
            throw new IllegalArgumentException("Unable to parse base64 string: illegal characters");
        }
        int missingOctets = StringsKt.endsWith$default((String)str, (String)"==", (boolean)false, (int)2, null) ? 2 : (StringsKt.endsWith$default((String)str, (String)"=", (boolean)false, (int)2, null) ? 1 : 0);
        byte[] result = new byte[3 * (str.length() / 4)];
        int i = 0;
        int j = 0;
        while (i < str.length()) {
            int buffer = Base64Kt.getBase64Code(str.charAt(i)) << 18 | Base64Kt.getBase64Code(str.charAt(i + 1)) << 12 | Base64Kt.getBase64Code(str.charAt(i + 2)) << 6 | Base64Kt.getBase64Code(str.charAt(i + 3));
            result[j] = (byte)(buffer >> 16 & 0xFF);
            result[j + 1] = (byte)(buffer >> 8 & 0xFF);
            result[j + 2] = (byte)(buffer & 0xFF);
            i += 4;
            j += 3;
        }
        return ArraysKt.sliceArray((byte[])result, (IntRange)RangesKt.until((int)0, (int)(result.length - missingOctets)));
    }

    @NotNull
    public static final byte[] decodeBase64Compact(@NotNull String $this$decodeBase64Compact) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64Compact, (String)"<this>");
        StringBuilder x = new StringBuilder(reSpaces.replace((CharSequence)$this$decodeBase64Compact, ""));
        while (x.length() % 4 != 0) {
            x.append('=');
        }
        String string = x.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Base64Kt.decodeBase64(string);
    }

    @NotNull
    public static final String encodeToBase64Compact(@NotNull byte[] $this$encodeToBase64Compact) {
        int end;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToBase64Compact, (String)"<this>");
        String result = Base64Kt.encodeToBase64($this$encodeToBase64Compact);
        for (end = result.length() - 1; end > 0 && result.charAt(end) == '='; --end) {
        }
        return StringsKt.slice((String)result, (IntRange)new IntRange(0, end));
    }

    @NotNull
    public static final String encodeToBase64Url(@NotNull byte[] $this$encodeToBase64Url) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToBase64Url, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)Base64Kt.encodeToBase64Compact($this$encodeToBase64Url), (char)'+', (char)'-', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final byte[] decodeBase64Url(@NotNull String $this$decodeBase64Url) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64Url, (String)"<this>");
        return Base64Kt.decodeBase64Compact(StringsKt.replace$default((String)StringsKt.replace$default((String)$this$decodeBase64Url, (char)'-', (char)'+', (boolean)false, (int)4, null), (char)'_', (char)'/', (boolean)false, (int)4, null));
    }

    private static final int encodeToBase64$b(byte[] $this_encodeToBase64, int index) {
        return $this_encodeToBase64[index] & 0xFF;
    }

    static {
        Object[] objectArray = new Integer[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 62, 255, 255, 255, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 255, 255, 255, 0, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
        base64codes = objectArray;
        objectArray = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "+", "/"};
        base64abc = objectArray;
        reSpaces = new Regex("\\s+");
    }
}

