/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.sprintf;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.sergeych.sprintf.ExponentFormatterKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u0015\u001a\u00020\nJ\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R&\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\n8F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/sergeych/sprintf/ExponentFormatter;", "", "value", "", "<init>", "(D)V", "getValue", "()D", "mantissa", "getMantissa", "", "exponent", "getExponent", "()I", "setExponent", "(I)V", "mstr", "", "strExponent", "scientific", "width", "fractionWidth", "toString", "mp_stools"})
public final class ExponentFormatter {
    private final double value;
    private double mantissa;
    private int exponent;
    @NotNull
    private final String mstr;
    @NotNull
    private String strExponent;

    public ExponentFormatter(double value) {
        this.value = value;
        double x = Math.abs(this.value);
        this.setExponent((int)Math.log10(x));
        if (this.getExponent() < 0) {
            int n = this.getExponent();
            this.setExponent(n + -1);
        }
        this.mantissa = x / Math.pow(10.0, this.getExponent());
        if (this.value < 0.0) {
            this.mantissa = -this.mantissa;
        }
        this.mstr = String.valueOf(this.mantissa);
        this.strExponent = "" + 'e' + this.getExponent();
    }

    public final double getValue() {
        return this.value;
    }

    public final double getMantissa() {
        return this.mantissa;
    }

    public final int getExponent() {
        return this.exponent;
    }

    private final void setExponent(int value) {
        this.exponent = value;
        this.strExponent = "" + 'e' + this.getExponent();
    }

    @NotNull
    public final String scientific(int width, int fractionWidth) {
        int minLength;
        int n = minLength = this.mantissa < 0.0 ? 2 : 1;
        if (width == 0) {
            return this.mstr + this.strExponent;
        }
        if (fractionWidth < 0 && width > 0) {
            int l = width - this.strExponent.length();
            if (l < minLength) {
                l = minLength;
            }
            return ExponentFormatter.scientific$mpart(this, l) + this.strExponent;
        }
        if (fractionWidth < 0 && width < 0) {
            return this.mstr + this.strExponent;
        }
        if (fractionWidth == 0) {
            return this.mstr.charAt(0) + this.strExponent;
        }
        return ExponentFormatter.scientific$mpart(this, minLength + 1 + fractionWidth) + this.strExponent;
    }

    public static /* synthetic */ String scientific$default(ExponentFormatter exponentFormatter, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return exponentFormatter.scientific(n, n2);
    }

    @NotNull
    public String toString() {
        return "" + this.mantissa + 'e' + this.getExponent();
    }

    private static final String scientific$mpart(ExponentFormatter this$0, int length) {
        StringBuilder result;
        int l = length;
        if (l > this$0.mstr.length()) {
            l = this$0.mstr.length();
        }
        if ((result = new StringBuilder(StringsKt.slice((String)this$0.mstr, (IntRange)RangesKt.until((int)0, (int)l)))).length() == this$0.mstr.length()) {
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        char nextDigit = this$0.mstr.charAt(result.length());
        if (nextDigit == '.') {
            if (result.length() + 1 >= this$0.mstr.length()) {
                String string = result.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            nextDigit = this$0.mstr.charAt(result.length() + 1);
        }
        if (StringsKt.contains$default((CharSequence)"56789", (char)nextDigit, (boolean)false, (int)2, null)) {
            Pair pair = ExponentFormatterKt.roundUp$default(result, 0, 0, false, 14, null);
            String m = (String)pair.component1();
            boolean ovf = (Boolean)pair.component2();
            if (!ovf) {
                return m;
            }
            int n = this$0.getExponent();
            this$0.setExponent(n + 1);
            int pointPos = StringsKt.indexOf$default((CharSequence)m, (char)'.', (int)0, (boolean)false, (int)6, null);
            StringBuilder mb = new StringBuilder(m);
            if (pointPos == -1) {
                return m;
            }
            StringBuilder stringBuilder = mb.deleteCharAt(pointPos);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"deleteCharAt(...)");
            String string = stringBuilder.insert(pointPos - 1, '.').toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

