/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.sprintf;

import java.time.DayOfWeek;
import java.time.Month;
import java.util.List;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ULong;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlinx.datetime.DayOfWeekKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import net.sergeych.sprintf.ExponentFormatterKt;
import net.sergeych.sprintf.LocaleSpecificMonthNameKt;
import net.sergeych.sprintf.Positioning;
import net.sergeych.sprintf.Sprintf;
import net.sergeych.sprintf.SprintfKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0000\u0018\u0000 :2\u00020\u0001:\u00029:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u001aH\u0002J\b\u0010,\u001a\u00020 H\u0002J\b\u0010-\u001a\u00020 H\u0002J\u0010\u0010.\u001a\u00020 2\u0006\u0010+\u001a\u00020\u001aH\u0002J\b\u0010/\u001a\u00020 H\u0002J\b\u00100\u001a\u00020 H\u0002J\u0012\u00101\u001a\u00020 2\b\b\u0002\u00102\u001a\u00020\u001aH\u0002J\u001a\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020%2\b\b\u0002\u00105\u001a\u00020%H\u0002J\b\u00106\u001a\u00020 H\u0002J\u0010\u00107\u001a\u00020 2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0010\u00108\u001a\u00020 2\u0006\u0010+\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006;"}, d2={"Lnet/sergeych/sprintf/Specification;", "", "parent", "Lnet/sergeych/sprintf/Sprintf;", "index", "", "<init>", "(Lnet/sergeych/sprintf/Sprintf;I)V", "getParent", "()Lnet/sergeych/sprintf/Sprintf;", "getIndex", "()I", "setIndex", "(I)V", "stage", "Lnet/sergeych/sprintf/Specification$Stage;", "size", "fractionalPartSize", "positioninig", "Lnet/sergeych/sprintf/Positioning;", "fillChar", "", "currentPart", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "explicitPlus", "", "done", "indexIsOverriden", "isScanningFlags", "()Z", "scan", "", "scan$mp_stools", "invalidFormat", "", "message", "", "time", "Lkotlinx/datetime/LocalDateTime;", "getTime", "()Lkotlinx/datetime/LocalDateTime;", "createTimeField", "upperCase", "createStringField", "createIntegerField", "createHexField", "createOctalField", "createCharacter", "endStage", "setDone", "insertField", "text", "prefix", "createFloat", "createScientific", "createAutoFloat", "Stage", "Companion", "mp_stools"})
public final class Specification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sprintf parent;
    private int index;
    @NotNull
    private Stage stage;
    private int size;
    private int fractionalPartSize;
    @NotNull
    private Positioning positioninig;
    private char fillChar;
    @NotNull
    private StringBuilder currentPart;
    private boolean explicitPlus;
    private boolean done;
    private boolean indexIsOverriden;
    @NotNull
    private static final Lazy<List<String>> englishMonthNames$delegate = LazyKt.lazy(Specification::englishMonthNames_delegate$lambda$2);
    @NotNull
    private static final Lazy<List<String>> englishWeekDayNames$delegate = LazyKt.lazy(Specification::englishWeekDayNames_delegate$lambda$3);

    public Specification(@NotNull Sprintf parent, int index) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.index = index;
        this.stage = Stage.FLAGS;
        this.size = -1;
        this.fractionalPartSize = -1;
        this.positioninig = Positioning.RIGHT;
        this.fillChar = (char)32;
        this.currentPart = new StringBuilder();
    }

    @NotNull
    public final Sprintf getParent() {
        return this.parent;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    private final boolean isScanningFlags() {
        return this.stage == Stage.FLAGS;
    }

    public final void scan$mp_stools() {
        block4: while (!this.done) {
            char ch = this.parent.nextChar$mp_stools();
            char c = ch;
            if (c == '-' || c == '^') {
                if (!this.isScanningFlags()) {
                    this.invalidFormat("unexpected " + ch);
                    throw new KotlinNothingValueException();
                }
                this.positioninig = ch == '-' ? Positioning.LEFT : Positioning.CENTER;
                continue;
            }
            if (c == '+') {
                if (!this.isScanningFlags()) {
                    this.invalidFormat("unexpected " + ch);
                    throw new KotlinNothingValueException();
                }
                this.explicitPlus = true;
                continue;
            }
            if (StringsKt.contains$default((CharSequence)"*#_=", (char)c, (boolean)false, (int)2, null)) {
                if (!this.isScanningFlags()) {
                    this.invalidFormat("bad fill char " + ch + " position");
                    throw new KotlinNothingValueException();
                }
                this.fillChar = ch;
                continue;
            }
            if (c == '0') {
                if (this.isScanningFlags()) {
                    this.fillChar = (char)48;
                    continue;
                }
                this.currentPart.append(ch);
                continue;
            }
            if (StringsKt.contains$default((CharSequence)"123456789", (char)c, (boolean)false, (int)2, null)) {
                if (this.stage == Stage.FLAGS) {
                    this.stage = Stage.LENGTH;
                }
                this.currentPart.append(ch);
                continue;
            }
            if (c == '$' || c == '!') {
                if (this.stage != Stage.LENGTH) {
                    this.invalidFormat("unexpected " + ch + " position");
                    throw new KotlinNothingValueException();
                }
                if (this.indexIsOverriden) {
                    this.invalidFormat("argument number '" + ch + "' should occur only once");
                    throw new KotlinNothingValueException();
                }
                this.indexIsOverriden = true;
                String string = this.currentPart.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.index = Integer.parseInt(string) - 1;
                this.parent.pushbackArgumentIndex();
                StringsKt.clear((StringBuilder)this.currentPart);
                continue;
            }
            if (c == 's') {
                this.createStringField();
                continue;
            }
            if (c == 'd' || c == 'i') {
                this.createIntegerField();
                continue;
            }
            if (c == 'o') {
                this.createOctalField();
                continue;
            }
            if (c == 'x') {
                this.createHexField(false);
                continue;
            }
            if (c == 'X') {
                this.createHexField(true);
                continue;
            }
            if (c == 'f' || c == 'F') {
                this.createFloat();
                continue;
            }
            if (c == 'E') {
                this.createScientific(true);
                continue;
            }
            if (c == 'e') {
                this.createScientific(false);
                continue;
            }
            if (c == 'g') {
                this.createAutoFloat(true);
                continue;
            }
            if (c == 'G') {
                this.createAutoFloat(false);
                continue;
            }
            if (c == 'c' || c == 'C') {
                this.createCharacter();
                continue;
            }
            if (c == 't') {
                this.createTimeField(false);
                continue;
            }
            if (c == 'T') {
                this.createTimeField(true);
                continue;
            }
            if (c == '.') {
                switch (WhenMappings.$EnumSwitchMapping$0[this.stage.ordinal()]) {
                    case 1: {
                        this.stage = Stage.FRACTION;
                        continue block4;
                    }
                    case 2: {
                        this.endStage(false);
                        this.stage = Stage.FRACTION;
                        continue block4;
                    }
                }
                this.invalidFormat("can't parse specification: unexpected '.'");
                throw new KotlinNothingValueException();
            }
            this.invalidFormat("unexpected character '" + ch + '\'');
            throw new KotlinNothingValueException();
        }
    }

    private final Void invalidFormat(String message) {
        this.parent.invalidFormat$mp_stools(message);
        throw new KotlinNothingValueException();
    }

    private final LocalDateTime getTime() {
        return this.parent.getLocalDateTime(this.index);
    }

    private final void createTimeField(boolean upperCase) {
        String string;
        char ch = this.parent.nextChar$mp_stools();
        Specification.endStage$default(this, false, 1, null);
        switch (ch) {
            case 'H': {
                Object[] objectArray = new Object[]{this.getTime().getHour()};
                string = SprintfKt.sprintf("%02d", objectArray);
                break;
            }
            case 'k': {
                Object[] objectArray = new Object[]{this.getTime().getHour()};
                string = SprintfKt.sprintf("%d", objectArray);
                break;
            }
            case 'I': 
            case 'l': {
                int t = this.getTime().getHour();
                if (t > 12) {
                    t -= 12;
                }
                if (ch == 'I') {
                    Object[] objectArray = new Object[]{t};
                    string = SprintfKt.sprintf("%02d", objectArray);
                    break;
                }
                string = String.valueOf(t);
                break;
            }
            case 'M': {
                Object[] t = new Object[]{this.getTime().getMinute()};
                string = SprintfKt.sprintf("%02d", t);
                break;
            }
            case 'S': {
                Object[] t = new Object[]{this.getTime().getSecond()};
                string = SprintfKt.sprintf("%02d", t);
                break;
            }
            case 'L': {
                Object[] t = new Object[]{this.getTime().getNanosecond() / 1000000};
                string = SprintfKt.sprintf("%03d", t);
                break;
            }
            case 'N': {
                Object[] t = new Object[]{this.getTime().getNanosecond()};
                string = SprintfKt.sprintf("%09d", t);
                break;
            }
            case 'p': {
                if (upperCase) {
                    if (this.getTime().getHour() > 12) {
                        string = "PM";
                        break;
                    }
                    string = "AM";
                    break;
                }
                if (this.getTime().getHour() > 12) {
                    string = "pm";
                    break;
                }
                string = "am";
                break;
            }
            case 'z': {
                TimeZone tz = TimeZone.Companion.currentSystemDefault();
                string = StringsKt.replace$default((String)TimeZoneKt.offsetAt((TimeZone)tz, (Instant)TimeZoneKt.toInstant((LocalDateTime)this.getTime(), (TimeZone)tz)).toString(), (String)":", (String)"", (boolean)false, (int)4, null);
                break;
            }
            case 'Z': {
                TimeZone tz = TimeZone.Companion.currentSystemDefault();
                string = TimeZoneKt.offsetAt((TimeZone)tz, (Instant)TimeZoneKt.toInstant((LocalDateTime)this.getTime(), (TimeZone)tz)).toString();
                break;
            }
            case 's': {
                TimeZone tz = TimeZone.Companion.currentSystemDefault();
                string = String.valueOf(TimeZoneKt.toInstant((LocalDateTime)this.getTime(), (TimeZone)tz).getEpochSeconds());
                break;
            }
            case 'Q': {
                TimeZone tz = TimeZone.Companion.currentSystemDefault();
                string = String.valueOf(TimeZoneKt.toInstant((LocalDateTime)this.getTime(), (TimeZone)tz).toEpochMilliseconds());
                break;
            }
            case 'B': {
                string = Companion.getMonthName(MonthKt.getNumber((Month)this.getTime().getMonth()));
                break;
            }
            case 'b': 
            case 'h': {
                string = Companion.getAbbreviatedMonthName(MonthKt.getNumber((Month)this.getTime().getMonth()));
                break;
            }
            case 'e': {
                string = String.valueOf(this.getTime().getDayOfMonth());
                break;
            }
            case 'd': {
                Object[] tz = new Object[]{this.getTime().getDayOfMonth()};
                string = SprintfKt.sprintf("%02s", tz);
                break;
            }
            case 'm': {
                Object[] tz = new Object[]{MonthKt.getNumber((Month)this.getTime().getMonth())};
                string = SprintfKt.sprintf("%02s", tz);
                break;
            }
            case 'A': {
                string = Companion.getWeekDayName(this.getTime().getDayOfWeek());
                break;
            }
            case 'a': {
                string = Companion.getAbbreviatedWeekDayName(this.getTime().getDayOfWeek());
                break;
            }
            case 'y': {
                string = StringsKt.takeLast((String)String.valueOf(this.getTime().getYear()), (int)2);
                break;
            }
            case 'Y': {
                Object[] tz = new Object[]{this.getTime().getYear()};
                string = SprintfKt.sprintf("%04d", tz);
                break;
            }
            case 'j': {
                Object[] tz = new Object[]{this.getTime().getDayOfYear()};
                string = SprintfKt.sprintf("%03d", tz);
                break;
            }
            case 'R': {
                Object[] tz = new Object[]{this.getTime()};
                string = SprintfKt.sprintf("%1!tH:%1!tM", tz);
                break;
            }
            case 'r': {
                if (upperCase) {
                    Object[] tz = new Object[]{this.getTime()};
                    string = SprintfKt.sprintf("%1!tI:%1!tM:%1!tS %1!Tp", tz);
                    break;
                }
                Object[] tz = new Object[]{this.getTime()};
                string = SprintfKt.sprintf("%1!tI:%1!tM:%1!tS %1!tp", tz);
                break;
            }
            case 'T': {
                Object[] tz = new Object[]{this.getTime()};
                string = SprintfKt.sprintf("%tH:%1!tM:%1!tS", tz);
                break;
            }
            case 'D': {
                Object[] tz = new Object[]{this.getTime()};
                string = SprintfKt.sprintf("%tm/%1!td/%1!ty", tz);
                break;
            }
            case 'F': {
                Object[] tz = new Object[]{this.getTime()};
                string = SprintfKt.sprintf("%tY-%1!tm-%1!td", tz);
                break;
            }
            case 'c': {
                Object[] tz = new Object[]{this.getTime()};
                string = SprintfKt.sprintf("%ta %1!tb %1!td %1!tT %1!tZ %1!tY", tz);
                break;
            }
            case 'O': {
                TimeZone tz = TimeZone.Companion.currentSystemDefault();
                String offset = TimeZoneKt.offsetAt((TimeZone)tz, (Instant)TimeZoneKt.toInstant((LocalDateTime)this.getTime(), (TimeZone)tz)).toString();
                Object[] objectArray = new Object[]{this.getTime(), offset};
                string = SprintfKt.sprintf("%tFT%1!tT%s", objectArray);
                break;
            }
            case '#': {
                Object[] objectArray = new Object[]{TimeZoneKt.toInstant((LocalDateTime)this.getTime(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()))};
                string = SprintfKt.sprintf("%tY%1!tm%1!td%1!tH%1!tM%1!tS", objectArray);
                break;
            }
            default: {
                this.invalidFormat("unknown time field specificator: 't" + ch + '\'');
                throw new KotlinNothingValueException();
            }
        }
        String result = string;
        Specification.insertField$default(this, result, null, 2, null);
    }

    private final void createStringField() {
        Specification.endStage$default(this, false, 1, null);
        Specification.insertField$default(this, this.parent.getText$mp_stools(this.index), null, 2, null);
    }

    private final void createIntegerField() {
        Specification.endStage$default(this, false, 1, null);
        long number = this.parent.getNumber$mp_stools(this.index).longValue();
        if (number < 0L && this.fillChar == '0') {
            this.insertField(String.valueOf(-number), "-");
        } else if (this.explicitPlus && this.fillChar == '0' && number > 0L) {
            this.insertField(String.valueOf(number), "+");
        } else {
            Specification.insertField$default(this, this.explicitPlus && number > 0L ? "" + '+' + number : String.valueOf(number), null, 2, null);
        }
    }

    private final void createHexField(boolean upperCase) {
        String string;
        String text;
        String string2;
        Specification.endStage$default(this, false, 1, null);
        if (this.explicitPlus) {
            this.invalidFormat("'+' is incompatible with hex format");
            throw new KotlinNothingValueException();
        }
        Object src = this.parent.notNull(this.index);
        Number number = src instanceof Number ? (Number)((Number)src) : (Number)null;
        if (number == null) {
            throw new IllegalArgumentException("can't treat '" + src + "' as integer number");
        }
        long n = number.longValue();
        if (n >= 0L) {
            String string3 = Long.toString(n, CharsKt.checkRadix((int)16));
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        } else {
            long n2 = ULong.constructor-impl((long)n);
            String t = src instanceof Byte ? UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)(n2 & 0xFFL)), (int)16) : (src instanceof Short ? UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)(n2 & 0xFFFFL)), (int)16) : (src instanceof Integer ? UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)(n2 & 0xFFFFFFFFL)), (int)16) : UStringsKt.toString-JSWoG40((long)n2, (int)16)));
            string2 = text = this.size >= 0 ? StringsKt.take((String)t, (int)this.size) : t;
        }
        if (upperCase) {
            String string4 = text.toUpperCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        } else {
            String string5 = text.toLowerCase(Locale.ROOT);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        }
        Specification.insertField$default(this, string, null, 2, null);
    }

    private final void createOctalField() {
        Specification.endStage$default(this, false, 1, null);
        long number = this.parent.getNumber$mp_stools(this.index).longValue();
        if (this.explicitPlus) {
            this.invalidFormat("'+' is incompatible with oct format");
            throw new KotlinNothingValueException();
        }
        String string = Long.toString(number, CharsKt.checkRadix((int)8));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Specification.insertField$default(this, string, null, 2, null);
    }

    private final void createCharacter() {
        Specification.endStage$default(this, false, 1, null);
        Specification.insertField$default(this, String.valueOf(this.parent.getCharacter$mp_stools(this.index)), null, 2, null);
    }

    private final void endStage(boolean setDone) {
        if (setDone) {
            this.done = true;
        }
        if (((CharSequence)this.currentPart).length() > 0) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.stage.ordinal()]) {
                case 2: {
                    String string = this.currentPart.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    this.size = Integer.parseInt(string);
                    break;
                }
                case 3: {
                    String string = this.currentPart.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    this.fractionalPartSize = Integer.parseInt(string);
                    break;
                }
                case 1: {
                    this.invalidFormat("can't parse format specifier (error 7)");
                    throw new KotlinNothingValueException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            StringsKt.clear((StringBuilder)this.currentPart);
        }
    }

    static /* synthetic */ void endStage$default(Specification specification, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        specification.endStage(bl);
    }

    private final void insertField(String text, String prefix) {
        int l = text.length() + prefix.length();
        if (this.size < 0 || this.size < l) {
            this.parent.specificationDone$mp_stools(prefix + text);
        } else {
            int padStart = 0;
            int padEnd = 0;
            switch (WhenMappings.$EnumSwitchMapping$1[this.positioninig.ordinal()]) {
                case 1: {
                    padEnd = this.size - l;
                    break;
                }
                case 2: {
                    padStart = this.size - l;
                    break;
                }
                case 3: {
                    padStart = (this.size - l) / 2;
                    padEnd = this.size - padStart - l;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            StringBuilder result = new StringBuilder(prefix);
            while (padStart-- > 0) {
                result.append(this.fillChar);
            }
            result.append(text);
            while (padEnd-- > 0) {
                result.append(this.fillChar);
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.parent.specificationDone$mp_stools(string);
        }
    }

    static /* synthetic */ void insertField$default(Specification specification, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        specification.insertField(string, string2);
    }

    private final void createFloat() {
        Specification.endStage$default(this, false, 1, null);
        double number = this.parent.getNumber$mp_stools(this.index).doubleValue();
        String t = ExponentFormatterKt.fractionalFormat(number, this.size, this.fractionalPartSize);
        if (this.explicitPlus && this.fillChar == '0' && number > 0.0) {
            this.insertField(t, "+");
        } else {
            Specification.insertField$default(this, this.explicitPlus && number > 0.0 ? '+' + t : t, null, 2, null);
        }
    }

    private final void createScientific(boolean upperCase) {
        String string;
        Specification.endStage$default(this, false, 1, null);
        double number = this.parent.getNumber$mp_stools(this.index).doubleValue();
        String it = ExponentFormatterKt.scientificFormat(number, this.size, this.fractionalPartSize);
        boolean bl = false;
        if (upperCase) {
            String string2 = it.toUpperCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        } else {
            String string3 = it.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        }
        String t = string;
        if (this.explicitPlus && this.fillChar == '0' && number > 0.0) {
            this.insertField(t, "+");
        } else {
            Specification.insertField$default(this, this.explicitPlus && number > 0.0 ? '+' + t : t, null, 2, null);
        }
    }

    private final void createAutoFloat(boolean upperCase) {
        String string;
        Specification.endStage$default(this, false, 1, null);
        Number number = this.parent.getNumber$mp_stools(this.index);
        String it = number.toString();
        boolean bl = false;
        if (upperCase) {
            String string2 = it.toUpperCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        } else {
            String string3 = it.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        }
        String t = string;
        if (this.explicitPlus && this.fillChar == '0' && number.doubleValue() > 0.0) {
            this.insertField(t, "+");
        } else {
            Specification.insertField$default(this, this.explicitPlus && number.floatValue() > 0.0f ? '+' + t : t, null, 2, null);
        }
    }

    private static final List englishMonthNames_delegate$lambda$2() {
        char[] cArray = new char[]{' '};
        return StringsKt.split$default((CharSequence)"January February March April May June July August September October November December", (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    private static final List englishWeekDayNames_delegate$lambda$3() {
        char[] cArray = new char[]{' '};
        return StringsKt.split$default((CharSequence)"Monday Tuesday Wednesday Thursday Friday Saturday Sunday", (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0012\u001a\u00020\u00062\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015J\u0012\u0010\u0016\u001a\u00020\u00062\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0017"}, d2={"Lnet/sergeych/sprintf/Specification$Companion;", "", "<init>", "()V", "englishMonthNames", "", "", "getEnglishMonthNames", "()Ljava/util/List;", "englishMonthNames$delegate", "Lkotlin/Lazy;", "englishWeekDayNames", "getEnglishWeekDayNames", "englishWeekDayNames$delegate", "getAbbreviatedMonthName", "monthNumber", "", "getMonthName", "getWeekDayName", "d", "Ljava/time/DayOfWeek;", "Lkotlinx/datetime/DayOfWeek;", "getAbbreviatedWeekDayName", "mp_stools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEnglishMonthNames() {
            Lazy lazy = englishMonthNames$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<String> getEnglishWeekDayNames() {
            Lazy lazy = englishWeekDayNames$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final String getAbbreviatedMonthName(int monthNumber) {
            String string = LocaleSpecificMonthNameKt.LocaleSpecificAbbreviatedMonthName(monthNumber);
            if (string == null) {
                string = StringsKt.take((String)this.getMonthName(monthNumber), (int)3);
            }
            return string;
        }

        @NotNull
        public final String getMonthName(int monthNumber) {
            String string = LocaleSpecificMonthNameKt.LocaleSpecificMonthName(monthNumber);
            if (string == null) {
                string = this.getEnglishMonthNames().get(monthNumber - 1);
            }
            return string;
        }

        @NotNull
        public final String getWeekDayName(@NotNull DayOfWeek d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            int n = DayOfWeekKt.getIsoDayNumber((DayOfWeek)d);
            String string = LocaleSpecificMonthNameKt.LocaleSpecificDayName(n);
            if (string == null) {
                string = this.getEnglishWeekDayNames().get(n - 1);
            }
            return string;
        }

        @NotNull
        public final String getAbbreviatedWeekDayName(@NotNull DayOfWeek d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            int n = DayOfWeekKt.getIsoDayNumber((DayOfWeek)d);
            String string = LocaleSpecificMonthNameKt.LocaleSpecificAbbreviatedDayName(n);
            if (string == null) {
                string = StringsKt.take((String)this.getEnglishWeekDayNames().get(n - 1), (int)3);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/sergeych/sprintf/Specification$Stage;", "", "<init>", "(Ljava/lang/String;I)V", "FLAGS", "LENGTH", "FRACTION", "mp_stools"})
    public static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage FLAGS = new Stage();
        public static final /* enum */ Stage LENGTH = new Stage();
        public static final /* enum */ Stage FRACTION = new Stage();
        private static final /* synthetic */ Stage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String value) {
            return Enum.valueOf(Stage.class, value);
        }

        @NotNull
        public static EnumEntries<Stage> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stageArray = new Stage[]{Stage.FLAGS, Stage.LENGTH, Stage.FRACTION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Stage.values().length];
            try {
                nArray[Stage.FLAGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stage.LENGTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stage.FRACTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Positioning.values().length];
            try {
                nArray[Positioning.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Positioning.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Positioning.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

