/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.sprintf;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import net.sergeych.sprintf.ConvertToInstantKt;
import net.sergeych.sprintf.Specification;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0000J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b(J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0019\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u000eJ\u0006\u0010/\u001a\u00020&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnet/sergeych/sprintf/Sprintf;", "", "format", "", "args", "", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;)V", "getFormat", "()Ljava/lang/String;", "getArgs", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "pos", "", "specStart", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "currentIndex", "process", "nextChar", "", "nextChar$mp_stools", "invalidFormat", "", "reason", "invalidFormat$mp_stools", "toString", "getNumber", "", "index", "getNumber$mp_stools", "getText", "getText$mp_stools", "getCharacter", "getCharacter$mp_stools", "specificationDone", "", "text", "specificationDone$mp_stools", "getLocalDateTime", "Lkotlinx/datetime/LocalDateTime;", "notNullArg", "T", "(I)Ljava/lang/Object;", "notNull", "pushbackArgumentIndex", "mp_stools"})
public final class Sprintf {
    @NotNull
    private final String format;
    @NotNull
    private final Object[] args;
    private int pos;
    private int specStart;
    @NotNull
    private final StringBuilder result;
    private int currentIndex;

    public Sprintf(@NotNull String format, @NotNull Object[] args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.format = format;
        this.args = args;
        this.specStart = -1;
        this.result = new StringBuilder();
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    @NotNull
    public final Object[] getArgs() {
        return this.args;
    }

    @NotNull
    public final Sprintf process() {
        while (this.pos < this.format.length()) {
            int n = this.pos;
            this.pos = n + 1;
            char ch = this.format.charAt(n);
            if (ch == '%') {
                if (this.specStart == this.pos - 1) {
                    this.result.append(ch);
                    this.specStart = -1;
                    continue;
                }
                if (this.specStart < 0) {
                    this.specStart = this.pos;
                    continue;
                }
                this.invalidFormat$mp_stools("unexpected %");
                throw new KotlinNothingValueException();
            }
            if (this.specStart >= 0) {
                n = this.pos;
                this.pos = n + -1;
                n = this.currentIndex;
                this.currentIndex = n + 1;
                new Specification(this, n).scan$mp_stools();
                continue;
            }
            this.result.append(ch);
        }
        return this;
    }

    public final char nextChar$mp_stools() {
        if (this.pos >= this.format.length()) {
            this.invalidFormat$mp_stools("unexpected end of string inside format specification");
            throw new KotlinNothingValueException();
        }
        int n = this.pos;
        this.pos = n + 1;
        return this.format.charAt(n);
    }

    @NotNull
    public final Void invalidFormat$mp_stools(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        throw new IllegalArgumentException("bad format: " + reason + " at ofset " + (this.pos - 1) + " of \"" + this.format + '\"');
    }

    @NotNull
    public String toString() {
        String string = this.result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Number getNumber$mp_stools(int index) {
        return (Number)this.notNullArg(index);
    }

    @NotNull
    public final String getText$mp_stools(int index) {
        Object object = this.args[index];
        Intrinsics.checkNotNull((Object)object);
        return object.toString();
    }

    public final char getCharacter$mp_stools(int index) {
        return ((Character)this.notNullArg(index)).charValue();
    }

    public final void specificationDone$mp_stools(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.result.append(text);
        this.specStart = -1;
    }

    @NotNull
    public final LocalDateTime getLocalDateTime(int index) {
        Object t = this.notNullArg(index);
        Object t2 = t;
        return t2 instanceof Instant ? TimeZoneKt.toLocalDateTime((Instant)((Instant)t), (TimeZone)TimeZone.Companion.currentSystemDefault()) : (t2 instanceof LocalDateTime ? (LocalDateTime)t : (t2 instanceof LocalDate ? LocalDateKt.atTime$default((LocalDate)((LocalDate)t), (int)0, (int)0, (int)0, (int)0, (int)8, null) : TimeZoneKt.toLocalDateTime((Instant)ConvertToInstantKt.ConvertToInstant(t), (TimeZone)TimeZone.Companion.currentSystemDefault())));
    }

    public final <T> T notNullArg(int index) {
        Object object = this.args[index];
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    @NotNull
    public final Object notNull(int index) {
        Object object = this.args[index];
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    public final void pushbackArgumentIndex() {
        int n = this.currentIndex;
        this.currentIndex = n + -1;
    }
}

