/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.sergeych.lyng.Pos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0003J\r\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\bJ\b\u0010#\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u001e\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lnet/sergeych/lyng/MutablePos;", "", "from", "Lnet/sergeych/lyng/Pos;", "<init>", "(Lnet/sergeych/lyng/Pos;)V", "lines", "", "", "getLines", "()Ljava/util/List;", "value", "", "line", "getLine", "()I", "column", "getColumn", "end", "", "getEnd", "()Z", "toPos", "advance", "", "()Ljava/lang/Character;", "resetTo", "", "pos", "back", "currentChar", "getCurrentChar", "()C", "readFragment", "fragment", "toString", "lynglib"})
public final class MutablePos {
    @NotNull
    private final Pos from;
    @NotNull
    private final List<String> lines;
    private int line;
    private int column;

    public MutablePos(@NotNull Pos from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this.from = from;
        this.lines = this.from.getSource().getLines();
        this.line = this.from.getLine();
        this.column = this.from.getColumn();
    }

    @NotNull
    public final List<String> getLines() {
        return this.lines;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public final boolean getEnd() {
        return this.line == this.lines.size();
    }

    @NotNull
    public final Pos toPos() {
        return new Pos(this.from.getSource(), this.line, this.column);
    }

    @Nullable
    public final Character advance() {
        Character c;
        if (this.getEnd()) {
            return null;
        }
        String current = this.lines.get(this.line);
        if (this.column < current.length()) {
            int n = this.column;
            this.column = n + 1;
            c = Character.valueOf(this.getCurrentChar());
        } else {
            this.column = 0;
            ++this.line;
            c = this.line >= this.lines.size() ? null : Character.valueOf(this.getCurrentChar());
        }
        return c;
    }

    public final void resetTo(@NotNull Pos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.line = pos.getLine();
        this.column = pos.getColumn();
    }

    public final void back() {
        if (this.column > 0) {
            int n = this.column;
            this.column = n + -1;
        } else if (this.line > 0) {
            this.line += -1;
            this.column = this.lines.get(this.line).length() - 1;
        } else {
            throw new IllegalStateException("can't go back from line 0, column 0");
        }
    }

    public final char getCurrentChar() {
        if (this.getEnd()) {
            return '\u0000';
        }
        String current = this.lines.get(this.line);
        return this.column >= current.length() ? (char)'\n' : current.charAt(this.column);
    }

    public final boolean readFragment(@NotNull String fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Pos mark = this.toPos();
        int n = fragment.length();
        for (int i = 0; i < n; ++i) {
            char ch = fragment.charAt(i);
            if (this.getCurrentChar() != ch) {
                this.resetTo(mark);
                return false;
            }
            this.advance();
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "(" + this.line + ":" + this.column + ")";
    }
}

