/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.sergeych.lyng.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0000J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lnet/sergeych/lyng/Pos;", "", "source", "Lnet/sergeych/lyng/Source;", "line", "", "column", "<init>", "(Lnet/sergeych/lyng/Source;II)V", "getSource", "()Lnet/sergeych/lyng/Source;", "getLine", "()I", "getColumn", "toString", "", "back", "currentLine", "getCurrentLine", "()Ljava/lang/String;", "end", "", "getEnd", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "Companion", "lynglib"})
public final class Pos {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Source source;
    private final int line;
    private final int column;
    @NotNull
    private static final Pos builtIn = new Pos(Source.Companion.getBuiltIn(), 0, 0);
    @NotNull
    private static final Pos UNKNOWN = new Pos(Source.Companion.getUNKNOWN(), -1, -1);

    public Pos(@NotNull Source source, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.line = line;
        this.column = column;
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    @NotNull
    public String toString() {
        return this.source.getFileName() + ":" + (this.line + 1) + ":" + this.column;
    }

    @NotNull
    public final Pos back() {
        Pos pos;
        if (this.column > 0) {
            pos = new Pos(this.source, this.line, this.column - 1);
        } else if (this.line > 0) {
            pos = new Pos(this.source, this.line - 1, this.source.getLines().get(this.line - 1).length() - 1);
        } else {
            throw new IllegalStateException("can't go back from line 0, column 0");
        }
        return pos;
    }

    @NotNull
    public final String getCurrentLine() {
        return this.getEnd() ? "EOF" : (this.line >= 0 ? this.source.getLines().get(this.line) : "<no line information>");
    }

    public final boolean getEnd() {
        return this.line >= this.source.getLines().size();
    }

    @NotNull
    public final Source component1() {
        return this.source;
    }

    public final int component2() {
        return this.line;
    }

    public final int component3() {
        return this.column;
    }

    @NotNull
    public final Pos copy(@NotNull Source source, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new Pos(source, line, column);
    }

    public static /* synthetic */ Pos copy$default(Pos pos, Source source, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            source = pos.source;
        }
        if ((n3 & 2) != 0) {
            n = pos.line;
        }
        if ((n3 & 4) != 0) {
            n2 = pos.column;
        }
        return pos.copy(source, n, n2);
    }

    public int hashCode() {
        int result2 = this.source.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.line);
        result2 = result2 * 31 + Integer.hashCode(this.column);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pos)) {
            return false;
        }
        Pos pos = (Pos)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)pos.source)) {
            return false;
        }
        if (this.line != pos.line) {
            return false;
        }
        return this.column == pos.column;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lnet/sergeych/lyng/Pos$Companion;", "", "<init>", "()V", "builtIn", "Lnet/sergeych/lyng/Pos;", "getBuiltIn", "()Lnet/sergeych/lyng/Pos;", "UNKNOWN", "getUNKNOWN", "lynglib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pos getBuiltIn() {
            return builtIn;
        }

        @NotNull
        public final Pos getUNKNOWN() {
            return UNKNOWN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

