/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng;

import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sergeych.lyng.Pos;
import net.sergeych.lyng.ScriptError;
import net.sergeych.lyng.obj.ObjString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lnet/sergeych/lyng/Source;", "", "fileName", "", "text", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "getText", "lines", "", "getLines", "()Ljava/util/List;", "objSourceName", "Lnet/sergeych/lyng/obj/ObjString;", "getObjSourceName", "()Lnet/sergeych/lyng/obj/ObjString;", "objSourceName$delegate", "Lkotlin/Lazy;", "startPos", "Lnet/sergeych/lyng/Pos;", "getStartPos", "()Lnet/sergeych/lyng/Pos;", "posAt", "line", "", "column", "extractPackageName", "Companion", "lynglib"})
public final class Source {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileName;
    @NotNull
    private final String text;
    @NotNull
    private final List<String> lines;
    @NotNull
    private final Lazy objSourceName$delegate;
    @NotNull
    private final Pos startPos;
    @NotNull
    private static final Lazy<Source> builtIn$delegate = LazyKt.lazy(Source::builtIn_delegate$lambda$0);
    @NotNull
    private static final Lazy<Source> UNKNOWN$delegate = LazyKt.lazy(Source::UNKNOWN_delegate$lambda$0);

    public Source(@NotNull String fileName, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.fileName = fileName;
        this.text = text;
        char[] cArray = new char[]{'\n'};
        this.lines = StringsKt.split$default((CharSequence)this.text, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        this.objSourceName$delegate = LazyKt.lazy(() -> Source.objSourceName_delegate$lambda$0(this));
        this.startPos = new Pos(this, 0, 0);
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<String> getLines() {
        return this.lines;
    }

    @NotNull
    public final ObjString getObjSourceName() {
        Lazy lazy = this.objSourceName$delegate;
        return (ObjString)lazy.getValue();
    }

    @NotNull
    public final Pos getStartPos() {
        return this.startPos;
    }

    @NotNull
    public final Pos posAt(int line, int column) {
        return new Pos(this, line, column);
    }

    @NotNull
    public final String extractPackageName() {
        Iterator iterator2 = ((Iterable)this.lines).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2 = n++;
            String line = (String)iterator2.next();
            if (StringsKt.isBlank((CharSequence)line) || ((CharSequence)line).length() == 0) continue;
            if (StringsKt.startsWith$default((String)line, (String)"package ", (boolean)false, (int)2, null)) {
                String string = line.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return ((Object)StringsKt.trim((CharSequence)string)).toString();
            }
            throw new ScriptError(new Pos(this, n2, 0), "package declaration expected", null, 4, null);
        }
        throw new ScriptError(new Pos(this, 0, 0), "package declaration expected", null, 4, null);
    }

    private static final ObjString objSourceName_delegate$lambda$0(Source this$0) {
        return new ObjString(this$0.fileName);
    }

    private static final Source builtIn_delegate$lambda$0() {
        return new Source("built-in", "");
    }

    private static final Source UNKNOWN_delegate$lambda$0() {
        return new Source("UNKNOWN", "");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\r"}, d2={"Lnet/sergeych/lyng/Source$Companion;", "", "<init>", "()V", "builtIn", "Lnet/sergeych/lyng/Source;", "getBuiltIn", "()Lnet/sergeych/lyng/Source;", "builtIn$delegate", "Lkotlin/Lazy;", "UNKNOWN", "getUNKNOWN", "UNKNOWN$delegate", "lynglib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Source getBuiltIn() {
            Lazy lazy = builtIn$delegate;
            return (Source)lazy.getValue();
        }

        @NotNull
        public final Source getUNKNOWN() {
            Lazy lazy = UNKNOWN$delegate;
            return (Source)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

