/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.format;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J(\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u00a8\u0006\u0017"}, d2={"Lnet/sergeych/lyng/format/BraceUtils;", "", "<init>", "()V", "findMatchingOpenBrace", "", "text", "", "closeIndex", "(Ljava/lang/CharSequence;I)Ljava/lang/Integer;", "lineStart", "offset", "lineEnd", "findEnclosingBlockRange", "Lkotlin/ranges/IntRange;", "includeTrailingNewline", "", "lastIndexOf", "ch", "", "fromIndex", "indexOf", "toIndexExclusive", "lynglib"})
public final class BraceUtils {
    @NotNull
    public static final BraceUtils INSTANCE = new BraceUtils();

    private BraceUtils() {
    }

    @Nullable
    public final Integer findMatchingOpenBrace(@NotNull CharSequence text, int closeIndex) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (closeIndex < 0 || closeIndex >= text.length() || text.charAt(closeIndex) != '}') {
            return null;
        }
        int i = closeIndex;
        int balance = 0;
        while (i >= 0) {
            int lineStart;
            int slashes;
            char ch = text.charAt(i);
            if (ch == '\n' && (slashes = this.indexOf(text, '/', lineStart = this.lastIndexOf(text, '\n', i - 1) + 1, i)) >= 0 && slashes + 1 <= i && slashes + 1 < text.length() && text.charAt(slashes + 1) == '/') {
                i = slashes - 1;
                continue;
            }
            switch (ch) {
                case '}': {
                    ++balance;
                    break;
                }
                case '{': {
                    if (balance == 1) {
                        return i;
                    }
                    if (balance <= 1) break;
                    --balance;
                }
            }
            --i;
        }
        return null;
    }

    public final int lineStart(@NotNull CharSequence text, int offset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        for (int i = RangesKt.coerceIn((int)offset, (int)0, (int)text.length()) - 1; i >= 0; --i) {
            if (text.charAt(i) != '\n') continue;
            return i + 1;
        }
        return 0;
    }

    public final int lineEnd(@NotNull CharSequence text, int offset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        for (int i = RangesKt.coerceIn((int)offset, (int)0, (int)text.length()); i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            return i;
        }
        return text.length();
    }

    @Nullable
    public final IntRange findEnclosingBlockRange(@NotNull CharSequence text, int closeIndex, boolean includeTrailingNewline) {
        int ci;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        for (ci = RangesKt.coerceIn((int)closeIndex, (int)0, (int)text.length()); ci >= 0 && text.charAt(ci) != '}'; --ci) {
        }
        if (ci < 0) {
            return null;
        }
        Integer n = this.findMatchingOpenBrace(text, ci);
        if (n == null) {
            return null;
        }
        int open = n;
        int start = this.lineStart(text, open);
        int closeLineEnd = this.lineEnd(text, ci);
        int endExclusive = includeTrailingNewline && closeLineEnd < text.length() && text.charAt(closeLineEnd) == '\n' ? closeLineEnd + 1 : closeLineEnd;
        return RangesKt.until((int)start, (int)endExclusive);
    }

    public static /* synthetic */ IntRange findEnclosingBlockRange$default(BraceUtils braceUtils, CharSequence charSequence, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return braceUtils.findEnclosingBlockRange(charSequence, n, bl);
    }

    private final int lastIndexOf(CharSequence text, char ch, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (text.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private final int indexOf(CharSequence text, char ch, int fromIndex, int toIndexExclusive) {
        int to = RangesKt.coerceAtMost((int)toIndexExclusive, (int)text.length());
        for (int i = fromIndex; i < to; ++i) {
            if (text.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }
}

