/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.highlight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.sergeych.lyng.ParserKt;
import net.sergeych.lyng.Source;
import net.sergeych.lyng.Token;
import net.sergeych.lyng.highlight.HighlightKind;
import net.sergeych.lyng.highlight.HighlightSpan;
import net.sergeych.lyng.highlight.LyngHighlighter;
import net.sergeych.lyng.highlight.SimpleLyngHighlighterKt;
import net.sergeych.lyng.highlight.TextRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/sergeych/lyng/highlight/SimpleLyngHighlighter;", "Lnet/sergeych/lyng/highlight/LyngHighlighter;", "<init>", "()V", "highlight", "", "Lnet/sergeych/lyng/highlight/HighlightSpan;", "text", "", "lynglib"})
public final class SimpleLyngHighlighter
implements LyngHighlighter {
    @Override
    @NotNull
    public List<HighlightSpan> highlight(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Source src = new Source("<snippet>", text);
        List<Token> tokens = ParserKt.parseLyng(src);
        ArrayList raw = new ArrayList(tokens.size());
        for (Token t : tokens) {
            HighlightKind k;
            TextRange range;
            if (SimpleLyngHighlighterKt.access$kindOf(t.getType(), t.getValue()) == null) continue;
            int start = SimpleLyngHighlighterKt.offsetOf(src, t.getPos());
            if ((range = (switch (WhenMappings.$EnumSwitchMapping$0[t.getType().ordinal()]) {
                case 1, 2 -> SimpleLyngHighlighter.highlight$adjustQuoteSpan(text, start, '\"');
                case 3 -> SimpleLyngHighlighter.highlight$adjustQuoteSpan(text, start, '\'');
                case 4 -> {
                    int end = RangesKt.coerceAtMost((int)(start + 2 + t.getValue().length()), (int)text.length());
                    yield new TextRange(start, end);
                }
                default -> new TextRange(start, RangesKt.coerceAtMost((int)(start + t.getValue().length()), (int)text.length()));
            })).getEndExclusive() <= range.getStart()) continue;
            ((Collection)raw).add(new HighlightSpan(range, k));
        }
        List adjusted = SimpleLyngHighlighterKt.access$extendSingleLineCommentsToEol(text, raw);
        return SimpleLyngHighlighterKt.access$mergeAdjacent(adjusted);
    }

    private static final TextRange highlight$adjustQuoteSpan(String $text, int startOffset, char quoteChar) {
        int s = startOffset;
        if (s > 0 && $text.charAt(s - 1) == quoteChar) {
            --s;
        }
        int i = s + 1;
        while (i < $text.length()) {
            char ch = $text.charAt(i);
            if (ch == '\\') {
                i += i + 1 < $text.length() ? 2 : 1;
                continue;
            }
            if (ch == quoteChar) {
                return new TextRange(s, i + 1);
            }
            ++i;
        }
        return new TextRange(s, $text.length());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Token.Type.values().length];
            try {
                nArray[Token.Type.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.STRING2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.CHAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.HEX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

