/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.highlight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sergeych.lyng.Pos;
import net.sergeych.lyng.Source;
import net.sergeych.lyng.Token;
import net.sergeych.lyng.highlight.HighlightKind;
import net.sergeych.lyng.highlight.HighlightSpan;
import net.sergeych.lyng.highlight.TextRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u001a$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"offsetOf", "", "Lnet/sergeych/lyng/Source;", "pos", "Lnet/sergeych/lyng/Pos;", "reservedIdKeywords", "", "", "fallbackKeywordIds", "kindOf", "Lnet/sergeych/lyng/highlight/HighlightKind;", "type", "Lnet/sergeych/lyng/Token$Type;", "value", "mergeAdjacent", "", "Lnet/sergeych/lyng/highlight/HighlightSpan;", "spans", "extendSingleLineCommentsToEol", "text", "lynglib"})
public final class SimpleLyngHighlighterKt {
    @NotNull
    private static final Set<String> reservedIdKeywords;
    @NotNull
    private static final Set<String> fallbackKeywordIds;

    public static final int offsetOf(@NotNull Source $this$offsetOf, @NotNull Pos pos) {
        Intrinsics.checkNotNullParameter((Object)$this$offsetOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int off = 0;
        for (int i = 0; i < pos.getLine(); ++i) {
            off += $this$offsetOf.getLines().get(i).length() + 1;
        }
        return off += pos.getColumn();
    }

    private static final HighlightKind kindOf(Token.Type type2, String value) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> {
                if (reservedIdKeywords.contains(value)) {
                    yield HighlightKind.Keyword;
                }
                String v1 = value.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
                if (fallbackKeywordIds.contains(v1)) {
                    yield HighlightKind.Keyword;
                }
                yield HighlightKind.Identifier;
            }
            case 2, 3, 4 -> HighlightKind.Number;
            case 5, 6 -> HighlightKind.String;
            case 7 -> HighlightKind.Char;
            case 8 -> HighlightKind.Regex;
            case 9, 10 -> HighlightKind.Comment;
            case 11, 12, 13, 14, 15, 16, 17, 18, 19 -> HighlightKind.Punctuation;
            case 20, 21, 22, 23, 24, 25, 26, 27, 28 -> HighlightKind.Keyword;
            case 29, 30 -> HighlightKind.Label;
            case 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73 -> HighlightKind.Operator;
            case 74, 75 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final List<HighlightSpan> mergeAdjacent(List<HighlightSpan> spans) {
        if (spans.isEmpty()) {
            return spans;
        }
        ArrayList out = new ArrayList(spans.size());
        HighlightSpan prev = spans.get(0);
        int n = spans.size();
        for (int i = 1; i < n; ++i) {
            HighlightSpan cur = spans.get(i);
            if (cur.getKind() == prev.getKind() && cur.getRange().getStart() == prev.getRange().getEndExclusive()) {
                prev = new HighlightSpan(new TextRange(prev.getRange().getStart(), cur.getRange().getEndExclusive()), prev.getKind());
                continue;
            }
            ((Collection)out).add(prev);
            prev = cur;
        }
        ((Collection)out).add(prev);
        return out;
    }

    private static final List<HighlightSpan> extendSingleLineCommentsToEol(String text, List<HighlightSpan> spans) {
        if (spans.isEmpty()) {
            return spans;
        }
        ArrayList out = new ArrayList(spans.size());
        int i = 0;
        while (i < spans.size()) {
            HighlightSpan s = spans.get(i);
            if (s.getKind() == HighlightKind.Comment) {
                String ahead;
                int start = s.getRange().getStart();
                boolean bl = 0 <= start ? start < ((CharSequence)text).length() : false;
                if (bl) {
                    String string = text.substring(start, Math.min(text.length(), start + 2));
                    v2 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                } else {
                    v2 = ahead = "";
                }
                if (Intrinsics.areEqual((Object)ahead, (Object)"//")) {
                    int j;
                    int eol = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)start, (boolean)false, (int)4, null);
                    int newEnd = eol >= 0 ? eol : text.length();
                    for (j = i + 1; j < spans.size() && spans.get(j).getRange().getStart() < newEnd; ++j) {
                    }
                    ((Collection)out).add(new HighlightSpan(new TextRange(start, newEnd), s.getKind()));
                    i = j;
                    continue;
                }
            }
            ((Collection)out).add(s);
            ++i;
        }
        return out;
    }

    public static final /* synthetic */ HighlightKind access$kindOf(Token.Type type2, String value) {
        return SimpleLyngHighlighterKt.kindOf(type2, value);
    }

    public static final /* synthetic */ List access$extendSingleLineCommentsToEol(String text, List spans) {
        return SimpleLyngHighlighterKt.extendSingleLineCommentsToEol(text, spans);
    }

    public static final /* synthetic */ List access$mergeAdjacent(List spans) {
        return SimpleLyngHighlighterKt.mergeAdjacent(spans);
    }

    static {
        Object[] objectArray = new String[]{"constructor", "property"};
        reservedIdKeywords = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"and", "or", "not", "fun", "fn", "class", "enum", "val", "var", "import", "package", "private", "protected", "static", "open", "extern", "if", "else", "when", "while", "do", "for", "try", "catch", "finally", "throw", "return", "break", "continue", "this", "null", "true", "false"};
        fallbackKeywordIds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Token.Type.values().length];
            try {
                nArray[Token.Type.ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.REAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.HEX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.STRING2.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.CHAR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.REGEX.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.SINLGE_LINE_COMMENT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.MULTILINE_COMMENT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.LPAREN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.RPAREN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.LBRACE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.RBRACE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.LBRACKET.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.RBRACKET.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.COMMA.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.SEMICOLON.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.COLON.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.IN.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NOTIN.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.IS.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NOTIS.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.AS.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.ASNULL.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.AND.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.OR.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NOT.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.LABEL.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.ATLABEL.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.PLUS.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.MINUS.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.STAR.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.SLASH.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.PERCENT.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.ASSIGN.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.PLUSASSIGN.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.MINUSASSIGN.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.STARASSIGN.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.SLASHASSIGN.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.PERCENTASSIGN.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.PLUS2.ordinal()] = 42;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.MINUS2.ordinal()] = 43;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.EQ.ordinal()] = 44;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NEQ.ordinal()] = 45;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.LT.ordinal()] = 46;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.LTE.ordinal()] = 47;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.GT.ordinal()] = 48;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.GTE.ordinal()] = 49;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.REF_EQ.ordinal()] = 50;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.REF_NEQ.ordinal()] = 51;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.MATCH.ordinal()] = 52;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NOTMATCH.ordinal()] = 53;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.DOT.ordinal()] = 54;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.ARROW.ordinal()] = 55;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.EQARROW.ordinal()] = 56;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.QUESTION.ordinal()] = 57;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.COLONCOLON.ordinal()] = 58;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.SHL.ordinal()] = 59;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.SHR.ordinal()] = 60;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.ELLIPSIS.ordinal()] = 61;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.DOTDOT.ordinal()] = 62;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.DOTDOTLT.ordinal()] = 63;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NULL_COALESCE.ordinal()] = 64;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.ELVIS.ordinal()] = 65;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NULL_COALESCE_INDEX.ordinal()] = 66;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NULL_COALESCE_INVOKE.ordinal()] = 67;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NULL_COALESCE_BLOCKINVOKE.ordinal()] = 68;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.SHUTTLE.ordinal()] = 69;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.BITAND.ordinal()] = 70;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.BITOR.ordinal()] = 71;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.BITXOR.ordinal()] = 72;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.BITNOT.ordinal()] = 73;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.NEWLINE.ordinal()] = 74;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.EOF.ordinal()] = 75;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

