/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.miniast;

import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.sergeych.lyng.Pos;
import net.sergeych.lyng.miniast.MiniAstSink;
import net.sergeych.lyng.miniast.MiniBlock;
import net.sergeych.lyng.miniast.MiniClassDecl;
import net.sergeych.lyng.miniast.MiniDoc;
import net.sergeych.lyng.miniast.MiniFunDecl;
import net.sergeych.lyng.miniast.MiniImport;
import net.sergeych.lyng.miniast.MiniRange;
import net.sergeych.lyng.miniast.MiniScript;
import net.sergeych.lyng.miniast.MiniValDecl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/sergeych/lyng/miniast/MiniAstBuilder;", "Lnet/sergeych/lyng/miniast/MiniAstSink;", "<init>", "()V", "currentScript", "Lnet/sergeych/lyng/miniast/MiniScript;", "blocks", "Lkotlin/collections/ArrayDeque;", "Lnet/sergeych/lyng/miniast/MiniBlock;", "lastDoc", "Lnet/sergeych/lyng/miniast/MiniDoc;", "scriptDepth", "", "build", "onScriptStart", "", "start", "Lnet/sergeych/lyng/Pos;", "onScriptEnd", "end", "script", "onDocCandidate", "doc", "onImport", "node", "Lnet/sergeych/lyng/miniast/MiniImport;", "onFunDecl", "Lnet/sergeych/lyng/miniast/MiniFunDecl;", "onValDecl", "Lnet/sergeych/lyng/miniast/MiniValDecl;", "onClassDecl", "Lnet/sergeych/lyng/miniast/MiniClassDecl;", "onBlock", "lynglib"})
public final class MiniAstBuilder
implements MiniAstSink {
    @Nullable
    private MiniScript currentScript;
    @NotNull
    private final ArrayDeque<MiniBlock> blocks = new ArrayDeque();
    @Nullable
    private MiniDoc lastDoc;
    private int scriptDepth;

    @Nullable
    public final MiniScript build() {
        return this.currentScript;
    }

    @Override
    public void onScriptStart(@NotNull Pos start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        if (this.scriptDepth == 0) {
            this.currentScript = new MiniScript(new MiniRange(start, start), null, null, null, 14, null);
        }
        int n = this.scriptDepth;
        this.scriptDepth = n + 1;
    }

    @Override
    public void onScriptEnd(@NotNull Pos end, @NotNull MiniScript script) {
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.scriptDepth = RangesKt.coerceAtLeast((int)(this.scriptDepth - 1), (int)0);
        if (this.scriptDepth == 0) {
            MiniScript miniScript;
            MiniScript miniScript2 = this.currentScript;
            if (miniScript2 != null) {
                MiniScript miniScript3 = this.currentScript;
                Intrinsics.checkNotNull((Object)miniScript3);
                miniScript = MiniScript.copy$default(miniScript2, new MiniRange(miniScript3.getRange().getStart(), end), null, null, null, 14, null);
            } else {
                miniScript = null;
            }
            this.currentScript = miniScript;
        }
    }

    @Override
    public void onDocCandidate(@NotNull MiniDoc doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.lastDoc = doc;
    }

    @Override
    public void onImport(@NotNull MiniImport node) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object = this.currentScript;
            if (object == null || (object = ((MiniScript)object).getImports()) == null) break block0;
            object.add(node);
        }
    }

    @Override
    public void onFunDecl(@NotNull MiniFunDecl node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        MiniDoc miniDoc = node.getDoc();
        if (miniDoc == null) {
            miniDoc = this.lastDoc;
        }
        MiniFunDecl attach = MiniFunDecl.copy$default(node, null, null, null, null, null, miniDoc, null, 95, null);
        Object object = this.currentScript;
        if (object != null && (object = ((MiniScript)object).getDeclarations()) != null) {
            object.add(attach);
        }
        this.lastDoc = null;
    }

    @Override
    public void onValDecl(@NotNull MiniValDecl node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        MiniDoc miniDoc = node.getDoc();
        if (miniDoc == null) {
            miniDoc = this.lastDoc;
        }
        MiniValDecl attach = MiniValDecl.copy$default(node, null, null, false, null, null, miniDoc, null, 95, null);
        Object object = this.currentScript;
        if (object != null && (object = ((MiniScript)object).getDeclarations()) != null) {
            object.add(attach);
        }
        this.lastDoc = null;
    }

    @Override
    public void onClassDecl(@NotNull MiniClassDecl node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        MiniDoc miniDoc = node.getDoc();
        if (miniDoc == null) {
            miniDoc = this.lastDoc;
        }
        MiniClassDecl attach = MiniClassDecl.copy$default(node, null, null, null, null, null, null, miniDoc, null, 191, null);
        Object object = this.currentScript;
        if (object != null && (object = ((MiniScript)object).getDeclarations()) != null) {
            object.add(attach);
        }
        this.lastDoc = null;
    }

    @Override
    public void onBlock(@NotNull MiniBlock node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.blocks.addLast((Object)node);
    }
}

