/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lynon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UByteArray;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.sergeych.bintools.ByteChunk;
import net.sergeych.lynon.BitArray;
import net.sergeych.lynon.BitInput;
import net.sergeych.lynon.BitOutput;
import net.sergeych.lynon.Bit_toolsKt;
import net.sergeych.lynon.DecompressionException;
import net.sergeych.lynon.LzwKt;
import net.sergeych.lynon.MemoryBitOutput;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\f\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lnet/sergeych/lynon/LZW;", "", "<init>", "()V", "MAX_CODE_SIZE", "", "getMAX_CODE_SIZE", "()I", "STOP_CODE", "getSTOP_CODE", "MAX_DICT_SIZE", "getMAX_DICT_SIZE", "compress", "", "input", "", "bitOutput", "Lnet/sergeych/lynon/BitOutput;", "Lkotlin/UByteArray;", "compress-rto03Yo", "([BLnet/sergeych/lynon/BitOutput;)V", "Lnet/sergeych/lynon/BitArray;", "compress-GBYM_sE", "([B)Lnet/sergeych/lynon/BitArray;", "decompress", "compressed", "Lnet/sergeych/lynon/BitInput;", "resultSize", "decompress-1Yfv1ig", "(Lnet/sergeych/lynon/BitInput;I)[B", "lynglib"})
@SourceDebugExtension(value={"SMAP\nlzw.kt\nKotlin\n*S Kotlin\n*F\n+ 1 lzw.kt\nnet/sergeych/lynon/LZW\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,185:1\n37#2,2:186\n*S KotlinDebug\n*F\n+ 1 lzw.kt\nnet/sergeych/lynon/LZW\n*L\n142#1:186,2\n*E\n"})
public final class LZW {
    @NotNull
    public static final LZW INSTANCE = new LZW();
    private static final int MAX_CODE_SIZE = 17;
    private static final int STOP_CODE = (1 << MAX_CODE_SIZE) - 1;
    private static final int MAX_DICT_SIZE = MathKt.roundToInt((double)((double)STOP_CODE * 0.92));

    private LZW() {
    }

    public final int getMAX_CODE_SIZE() {
        return MAX_CODE_SIZE;
    }

    public final int getSTOP_CODE() {
        return STOP_CODE;
    }

    public final int getMAX_DICT_SIZE() {
        return MAX_DICT_SIZE;
    }

    public final void compress(@NotNull byte[] input, @NotNull BitOutput bitOutput) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)bitOutput, (String)"bitOutput");
        this.compress-rto03Yo(UByteArray.constructor-impl((byte[])input), bitOutput);
    }

    public final void compress-rto03Yo(@NotNull byte[] byArray, @NotNull BitOutput bitOutput) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"$v$c$kotlin-UByteArray$-input$0");
        Intrinsics.checkNotNullParameter((Object)bitOutput, (String)"bitOutput");
        Map dictionary = new LinkedHashMap();
        for (int i = 0; i < 256; ++i) {
            Map map2 = dictionary;
            Object object = new byte[]{UByte.constructor-impl((byte)((byte)i))};
            object = new ByteChunk(object, null);
            Integer n = i;
            map2.put(object, n);
        }
        int nextCode = 256;
        ByteChunk current = new ByteChunk(new byte[0], null);
        int n = UByteArray.getSize-impl((byte[])byArray);
        for (int i = 0; i < n; ++i) {
            byte by = UByteArray.get-w2LRezQ((byte[])byArray, (int)i);
            ByteChunk combined = LzwKt.access$plus-EK-6454(current, by);
            if (dictionary.containsKey(combined)) {
                current = combined;
                continue;
            }
            int size = Bit_toolsKt.sizeInBits(dictionary.size());
            Object v = dictionary.get(current);
            Intrinsics.checkNotNull(v);
            bitOutput.putBits(((Number)v).intValue(), size);
            if (dictionary.size() >= MAX_DICT_SIZE) {
                bitOutput.putBits(STOP_CODE, size);
                dictionary.clear();
                nextCode = 256;
                for (int i2 = 0; i2 < 256; ++i2) {
                    Map map3 = dictionary;
                    Object object = new byte[]{UByte.constructor-impl((byte)((byte)i2))};
                    object = new ByteChunk(object, null);
                    Integer n2 = i2;
                    map3.put(object, n2);
                }
            } else {
                dictionary.put(combined, nextCode++);
            }
            byte[] byArray2 = new byte[]{by};
            current = new ByteChunk(byArray2, null);
        }
        if (current.getSize() > 0) {
            int size = Bit_toolsKt.sizeInBits(dictionary.size());
            Object v = dictionary.get(current);
            Intrinsics.checkNotNull(v);
            bitOutput.putBits(((Number)v).intValue(), size);
        }
    }

    @NotNull
    public final BitArray compress-GBYM_sE(@NotNull byte[] byArray) {
        MemoryBitOutput memoryBitOutput;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"$v$c$kotlin-UByteArray$-input$0");
        MemoryBitOutput $this$compress_GBYM_sE_u24lambda_u240 = memoryBitOutput = new MemoryBitOutput();
        boolean bl = false;
        INSTANCE.compress-rto03Yo(byArray, $this$compress_GBYM_sE_u24lambda_u240);
        return memoryBitOutput.toBitArray();
    }

    @NotNull
    public final byte[] decompress-1Yfv1ig(@NotNull BitInput compressed, int resultSize) {
        Intrinsics.checkNotNullParameter((Object)compressed, (String)"compressed");
        Map dictionary = new LinkedHashMap();
        for (int i = 0; i < 256; ++i) {
            Map map2 = dictionary;
            Integer n = i;
            Object object = new byte[]{UByte.constructor-impl((byte)((byte)i))};
            object = UByteArray.box-impl((byte[])object);
            map2.put(n, object);
        }
        int nextCode = 256;
        int firstCode = (int)compressed.getBits-I7RO_PI(9);
        UByteArray uByteArray = (UByteArray)dictionary.get(firstCode);
        Object object = uByteArray != null ? uByteArray.unbox-impl() : null;
        if (object == null) {
            throw new DecompressionException("Invalid first compressed code: " + firstCode);
        }
        byte[] previous = object;
        List result2 = new ArrayList();
        CollectionsKt.addAll((Collection)result2, (Iterable)UByteArray.box-impl((byte[])previous));
        while (result2.size() < resultSize) {
            byte[] byArray;
            int codeSize = Bit_toolsKt.sizeInBits(nextCode + 1);
            ULong uLong = compressed.getBitsOrNull-JlBESG8(codeSize);
            if (uLong == null) {
                break;
            }
            int code = (int)uLong.unbox-impl();
            if (code == STOP_CODE) {
                nextCode = 256;
                dictionary.clear();
                for (int i = 0; i < 256; ++i) {
                    Map map3 = dictionary;
                    Integer n = i;
                    Object object2 = new byte[]{UByte.constructor-impl((byte)((byte)i))};
                    object2 = UByteArray.box-impl((byte[])object2);
                    map3.put(n, object2);
                }
                Object v = dictionary.get((int)compressed.getBits-I7RO_PI(9));
                Intrinsics.checkNotNull(v);
                previous = ((UByteArray)v).unbox-impl();
                continue;
            }
            if (dictionary.containsKey(code)) {
                Object v = dictionary.get(code);
                Intrinsics.checkNotNull(v);
                byArray = ((UByteArray)v).unbox-impl();
            } else if (code == nextCode) {
                byArray = UByteArray.constructor-impl((byte[])ArraysKt.plus((byte[])previous, (byte)UByteArray.get-w2LRezQ((byte[])previous, (int)0)));
            } else {
                throw new DecompressionException("Invalid compressed code: " + code);
            }
            byte[] current = byArray;
            CollectionsKt.addAll((Collection)result2, (Iterable)UByteArray.box-impl((byte[])current));
            dictionary.put(nextCode++, UByteArray.box-impl((byte[])UByteArray.constructor-impl((byte[])ArraysKt.plus((byte[])previous, (byte)UByteArray.get-w2LRezQ((byte[])current, (int)0)))));
            previous = current;
        }
        if (result2.size() != resultSize) {
            throw new DecompressionException("Decompressed size is not equal to expected: real/expected = " + result2.size() + "/" + resultSize);
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return UArraysKt.toUByteArray((UByte[])thisCollection$iv.toArray(new UByte[0]));
    }
}

