/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.bintools;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ByteArraySerializer;
import kotlinx.serialization.internal.StringSerializer;
import net.sergeych.bintools.DataKVStorageKt;
import net.sergeych.bintools.DataProvider;
import net.sergeych.bintools.DataSink;
import net.sergeych.bintools.DataSource;
import net.sergeych.bintools.KVStorage;
import net.sergeych.bipack.BipackDecoder;
import net.sergeych.bipack.BipackEncoder;
import net.sergeych.mp_logger.Log;
import net.sergeych.mp_logger.LogTag;
import net.sergeych.mp_logger.Loggable;
import net.sergeych.mp_logger.LoggableKt;
import net.sergeych.synctools.ProtectedOpImplementation;
import net.sergeych.synctools.ProtectedOp_jvmKt;
import net.sergeych.synctools.WaitHandle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u00012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J/\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u00150\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001b0\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\tH\u0096\u0002J\u001b\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u001fH\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u0004\u0018\u00010(X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0018\u0010-\u001a\u00020\tX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00063"}, d2={"Lnet/sergeych/bintools/DataKVStorage;", "Lnet/sergeych/bintools/KVStorage;", "Lnet/sergeych/mp_logger/Loggable;", "provider", "Lnet/sergeych/bintools/DataProvider;", "<init>", "(Lnet/sergeych/bintools/DataProvider;)V", "locks", "", "", "Lnet/sergeych/bintools/DataKVStorage$Lock;", "access", "Lnet/sergeych/synctools/ProtectedOpImplementation;", "keyIds", "", "lastId", "lockFor", "name", "recordName", "id", "read", "T", "f", "Lkotlin/Function1;", "Lnet/sergeych/bintools/DataSource;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "write", "", "Lnet/sergeych/bintools/DataSink;", "deleteEntry", "get", "", "key", "set", "value", "keys", "", "getKeys", "()Ljava/util/Set;", "logLevel", "Lnet/sergeych/mp_logger/Log$Level;", "getLogLevel", "()Lnet/sergeych/mp_logger/Log$Level;", "setLogLevel", "(Lnet/sergeych/mp_logger/Log$Level;)V", "logTag", "getLogTag", "()Ljava/lang/String;", "setLogTag", "(Ljava/lang/String;)V", "Lock", "mp_bintools"})
@SourceDebugExtension(value={"SMAP\nDataKVStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataKVStorage.kt\nnet/sergeych/bintools/DataKVStorage\n+ 2 ProtectedOp.kt\nnet/sergeych/synctools/ProtectedOpKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BipackDecoder.kt\nnet/sergeych/bipack/BipackDecoder$Companion\n+ 6 BipackEncoder.kt\nnet/sergeych/bipack/BipackEncoder$Companion\n*L\n1#1,135:1\n34#2,6:136\n34#2,6:149\n34#2,3:155\n38#2,2:159\n34#2,6:161\n34#2,6:167\n381#3,7:142\n1#4:158\n144#5:173\n144#5:174\n144#5:175\n125#6:176\n125#6:177\n*S KotlinDebug\n*F\n+ 1 DataKVStorage.kt\nnet/sergeych/bintools/DataKVStorage\n*L\n54#1:136,6\n80#1:149,6\n94#1:155,3\n94#1:159,2\n106#1:161,6\n134#1:167,6\n73#1:142,7\n61#1:173\n116#1:174\n118#1:175\n128#1:176\n129#1:177\n*E\n"})
public final class DataKVStorage
implements KVStorage,
Loggable {
    private final /* synthetic */ LogTag $$delegate_0;
    @NotNull
    private final DataProvider provider;
    @NotNull
    private final Map<String, Lock> locks;
    @NotNull
    private final ProtectedOpImplementation access;
    @NotNull
    private final Map<String, Integer> keyIds;
    private int lastId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataKVStorage(@NotNull DataProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.$$delegate_0 = new LogTag("DKVS" + DataKVStorageKt.access$getAc$p().incrementAndGet(), null, 2, null);
        this.provider = provider;
        this.locks = new LinkedHashMap();
        this.access = ProtectedOp_jvmKt.ProtectedOp();
        this.keyIds = new LinkedHashMap();
        ProtectedOpImplementation $this$withLock$iv = this.access;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            boolean bl = false;
            for (String fn : this.provider.list()) {
                LoggableKt.debug((Loggable)this, () -> DataKVStorage.lambda$4$lambda$0(fn));
                if (StringsKt.endsWith$default((String)fn, (String)".d", (boolean)false, (int)2, null)) {
                    int id = Integer.parseInt(StringsKt.dropLast((String)fn, (int)2), CharsKt.checkRadix((int)16));
                    LoggableKt.debug((Loggable)this, () -> DataKVStorage.lambda$4$lambda$1(fn, id));
                    String name = (String)this.provider.read(fn, DataKVStorage::lambda$4$lambda$2);
                    Integer n = id;
                    this.keyIds.put(name, n);
                    if (id <= this.lastId) continue;
                    this.lastId = id;
                    continue;
                }
                LoggableKt.debug((Loggable)this, () -> DataKVStorage.lambda$4$lambda$3(fn));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withLock$iv.unlock();
        }
    }

    private final Lock lockFor(String name) {
        Lock lock;
        Map<String, Lock> $this$getOrPut$iv = this.locks;
        boolean $i$f$getOrPut = false;
        Lock value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            Lock answer$iv = new Lock(name);
            $this$getOrPut$iv.put(name, answer$iv);
            lock = answer$iv;
        } else {
            lock = value$iv;
        }
        return lock;
    }

    private final String recordName(int id) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toString(id, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).append(".d").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T read(String name, Function1<? super DataSource, ? extends T> f) {
        Lock lock = null;
        Ref.IntRef id = new Ref.IntRef();
        ProtectedOpImplementation $this$withLock$iv = this.access;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            boolean bl = false;
            Integer n = this.keyIds.get(name);
            if (n == null) {
                throw new DataProvider.NotFoundException(null, null, 3, null);
            }
            id.element = n;
            lock = this.lockFor(name);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return lock.lockRead(() -> DataKVStorage.read$lambda$7(this, id, f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void write(String name, Function1<? super DataSink, Unit> f) {
        Lock lock = null;
        Ref.IntRef id = new Ref.IntRef();
        ProtectedOpImplementation $this$withLock$iv = this.access;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            int n;
            boolean bl = false;
            Ref.IntRef intRef = id;
            Integer n2 = this.keyIds.get(name);
            if (n2 != null) {
                n = n2;
            } else {
                void it;
                int n3;
                ++this.lastId;
                int n4 = n3 = this.lastId;
                Ref.IntRef intRef2 = intRef;
                boolean bl2 = false;
                Integer n5 = (int)it;
                this.keyIds.put(name, n5);
                intRef = intRef2;
                n = n3;
            }
            intRef.element = n;
            lock = this.lockFor(name);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withLock$iv.unlock();
        }
        lock.lockExclusive(() -> DataKVStorage.write$lambda$10(this, id, f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteEntry(String name) {
        if (!this.keyIds.containsKey(name)) {
            return;
        }
        ProtectedOpImplementation $this$withLock$iv = this.access;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            boolean bl = false;
            Integer n = this.keyIds.get(name);
            if (n == null) {
                return;
            }
            int id = n;
            this.provider.delete(this.recordName(id));
            this.locks.remove(name);
            Integer n2 = this.keyIds.remove(name);
        }
        finally {
            $this$withLock$iv.unlock();
        }
    }

    @Override
    @Nullable
    public byte[] get(@NotNull String key) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            byArray = (byte[])this.read(key, DataKVStorage::get$lambda$12);
        }
        catch (DataProvider.NotFoundException notFoundException) {
            byArray = null;
        }
        return byArray;
    }

    @Override
    public void set(@NotNull String key, @Nullable byte[] value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            this.deleteEntry(key);
        } else {
            this.write(key, (Function1<? super DataSink, Unit>)((Function1)arg_0 -> DataKVStorage.set$lambda$13(key, value, arg_0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<String> getKeys() {
        Set<String> set;
        ProtectedOpImplementation $this$withLock$iv = this.access;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            boolean bl = false;
            set = this.keyIds.keySet();
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return set;
    }

    @Override
    public boolean contains(@NotNull String key) {
        return KVStorage.DefaultImpls.contains(this, key);
    }

    @Override
    public int getSize() {
        return KVStorage.DefaultImpls.getSize(this);
    }

    @Override
    public void clear() {
        KVStorage.DefaultImpls.clear(this);
    }

    @Override
    public boolean isEmpty() {
        return KVStorage.DefaultImpls.isEmpty(this);
    }

    @Override
    public boolean isNotEmpty() {
        return KVStorage.DefaultImpls.isNotEmpty(this);
    }

    @Override
    public void addAll(@NotNull KVStorage other) {
        KVStorage.DefaultImpls.addAll(this, other);
    }

    @Override
    public void delete(@NotNull String key) {
        KVStorage.DefaultImpls.delete(this, key);
    }

    @NotNull
    public String getLogTag() {
        return this.$$delegate_0.getLogTag();
    }

    public void setLogTag(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.$$delegate_0.setLogTag(value);
    }

    @Nullable
    public Log.Level getLogLevel() {
        return this.$$delegate_0.getLogLevel();
    }

    public void setLogLevel(@Nullable Log.Level value) {
        this.$$delegate_0.setLogLevel(value);
    }

    private static final String lambda$4$lambda$0(String $fn) {
        return "Scanning: " + $fn;
    }

    private static final String lambda$4$lambda$1(String $fn, int $id) {
        return "found data record: " + $fn + " -> " + $id;
    }

    private static final String lambda$4$lambda$2(DataSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BipackDecoder.Companion this_$iv = BipackDecoder.Companion;
        boolean $i$f$decode = false;
        return (String)this_$iv.decode(it, (DeserializationStrategy)StringSerializer.INSTANCE);
    }

    private static final String lambda$4$lambda$3(String $fn) {
        return "ignoring record " + $fn;
    }

    private static final Object read$lambda$7(DataKVStorage this$0, Ref.IntRef $id, Function1 $f) {
        return this$0.provider.read(this$0.recordName($id.element), $f);
    }

    private static final Unit write$lambda$10(DataKVStorage this$0, Ref.IntRef $id, Function1 $f) {
        this$0.provider.write(this$0.recordName($id.element), (Function1<? super DataSink, Unit>)$f);
        return Unit.INSTANCE;
    }

    private static final byte[] get$lambda$12(DataSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BipackDecoder.Companion this_$iv = BipackDecoder.Companion;
        boolean $i$f$decode = false;
        this_$iv.decode(it, (DeserializationStrategy)StringSerializer.INSTANCE);
        this_$iv = BipackDecoder.Companion;
        $i$f$decode = false;
        return (byte[])this_$iv.decode(it, (DeserializationStrategy)ByteArraySerializer.INSTANCE);
    }

    private static final Unit set$lambda$13(String $key, byte[] $value, DataSink it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BipackEncoder.Companion this_$iv = BipackEncoder.Companion;
        boolean $i$f$encode = false;
        this_$iv.encode((SerializationStrategy)StringSerializer.INSTANCE, $key, it);
        this_$iv = BipackEncoder.Companion;
        $i$f$encode = false;
        this_$iv.encode((SerializationStrategy)ByteArraySerializer.INSTANCE, $value, it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/sergeych/bintools/DataKVStorage$Lock;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "exclusive", "Lnet/sergeych/synctools/ProtectedOpImplementation;", "readerCount", "", "pulses", "Lnet/sergeych/synctools/WaitHandle;", "lockExclusive", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "lockRead", "component1", "copy", "equals", "", "other", "hashCode", "toString", "mp_bintools"})
    @SourceDebugExtension(value={"SMAP\nDataKVStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataKVStorage.kt\nnet/sergeych/bintools/DataKVStorage$Lock\n+ 2 ProtectedOp.kt\nnet/sergeych/synctools/ProtectedOpKt\n*L\n1#1,135:1\n34#2,6:136\n34#2,6:142\n34#2,6:148\n*S KotlinDebug\n*F\n+ 1 DataKVStorage.kt\nnet/sergeych/bintools/DataKVStorage$Lock\n*L\n27#1:136,6\n38#1:142,6\n41#1:148,6\n*E\n"})
    public static final class Lock {
        @NotNull
        private final String name;
        @NotNull
        private final ProtectedOpImplementation exclusive;
        private int readerCount;
        @NotNull
        private WaitHandle pulses;

        public Lock(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.exclusive = ProtectedOp_jvmKt.ProtectedOp();
            this.pulses = new WaitHandle();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T lockExclusive(@NotNull Function0<? extends T> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            while (true) {
                ProtectedOpImplementation $this$withLock$iv = this.exclusive;
                boolean $i$f$withLock = false;
                $this$withLock$iv.lock();
                try {
                    boolean bl = false;
                    if (this.readerCount == 0) {
                        Object object = f.invoke();
                        return (T)object;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$withLock$iv.unlock();
                }
                WaitHandle.await$default(this.pulses, 0L, 1, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T lockRead(@NotNull Function0<? extends T> f) {
            int n;
            Intrinsics.checkNotNullParameter(f, (String)"f");
            try {
                ProtectedOpImplementation $this$withLock$iv = this.exclusive;
                boolean $i$f$withLock = false;
                $this$withLock$iv.lock();
                try {
                    boolean bl = false;
                    int n2 = this.readerCount;
                    this.readerCount = n2 + 1;
                    n = n2;
                }
                finally {
                    $this$withLock$iv.unlock();
                }
                Object object = f.invoke();
                return (T)object;
            }
            finally {
                ProtectedOpImplementation $this$withLock$iv = this.exclusive;
                boolean $i$f$withLock = false;
                $this$withLock$iv.lock();
                try {
                    boolean bl = false;
                    n = this.readerCount;
                    this.readerCount = n + -1;
                    int n3 = n;
                }
                finally {
                    $this$withLock$iv.unlock();
                }
                if (this.readerCount == 0) {
                    this.pulses.wakeUp();
                }
            }
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Lock copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Lock(name);
        }

        public static /* synthetic */ Lock copy$default(Lock lock, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = lock.name;
            }
            return lock.copy(string);
        }

        @NotNull
        public String toString() {
            return "Lock(name=" + this.name + ')';
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Lock)) {
                return false;
            }
            Lock lock = (Lock)other;
            return Intrinsics.areEqual((Object)this.name, (Object)lock.name);
        }
    }
}

