/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.bintools;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.sergeych.bintools.DataProvider;
import net.sergeych.bintools.DataSink;
import net.sergeych.bintools.DataSource;
import net.sergeych.bintools.FileDataProviderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\t0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00110\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lnet/sergeych/bintools/FileDataProvider;", "Lnet/sergeych/bintools/DataProvider;", "folder", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getFolder", "()Ljava/nio/file/Path;", "read", "T", "name", "", "f", "Lkotlin/Function1;", "Lnet/sergeych/bintools/DataSource;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "write", "", "Lnet/sergeych/bintools/DataSink;", "delete", "list", "", "Source", "Sink", "mp_bintools"})
@SourceDebugExtension(value={"SMAP\nFileDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileDataProvider.kt\nnet/sergeych/bintools/FileDataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1#2:60\n774#3:61\n865#3,2:62\n1557#3:64\n1628#3,3:65\n*S KotlinDebug\n*F\n+ 1 FileDataProvider.kt\nnet/sergeych/bintools/FileDataProvider\n*L\n45#1:61\n45#1:62,2\n46#1:64\n46#1:65,3\n*E\n"})
public final class FileDataProvider
implements DataProvider {
    @NotNull
    private final Path folder;

    public FileDataProvider(@NotNull Path folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.folder = folder;
    }

    @NotNull
    public final Path getFolder() {
        return this.folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T read(@NotNull String name, @NotNull Function1<? super DataSource, ? extends T> f) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Path path = this.folder.resolve(name);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Object object2 = path;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream((Path)object2, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        object2 = inputStream;
        int n = 8192;
        object2 = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)object2;
            boolean bl = false;
            object = f.invoke((Object)new Source(it));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String name, @NotNull Function1<? super DataSink, Unit> f) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Path path = this.folder.resolve(name);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Object object = path;
        Object object2 = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object = outputStream;
        object2 = null;
        try {
            OutputStream it = (OutputStream)object;
            boolean bl = false;
            f.invoke((Object)new Sink(it));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @Override
    public void delete(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        System.out.println((Object)("file: " + this.folder + " -- " + name));
        Path path = this.folder.resolve(name);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Files.delete(path);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> list() {
        void $this$mapTo$iv$iv;
        Path it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)this.folder, null, (int)1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Path)element$iv$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!(Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Files.isReadable(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PathsKt.getName((Path)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/sergeych/bintools/FileDataProvider$Sink;", "Lnet/sergeych/bintools/DataSink;", "out", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "writeByte", "", "data", "", "mp_bintools"})
    public static final class Sink
    implements DataSink {
        @NotNull
        private final OutputStream out;

        public Sink(@NotNull OutputStream out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.out = out;
        }

        @Override
        public void writeByte(byte data) {
            this.out.write(data);
        }

        @Override
        public void writeByte(int data) {
            DataSink.DefaultImpls.writeByte(this, data);
        }

        @Override
        public void writeUByte-7apg3OU(byte data) {
            DataSink.DefaultImpls.writeUByte-7apg3OU(this, data);
        }

        @Override
        public void writeDouble(double value) {
            DataSink.DefaultImpls.writeDouble(this, value);
        }

        @Override
        public void writeFloat(float value) {
            DataSink.DefaultImpls.writeFloat(this, value);
        }

        @Override
        public void writeBytes(@NotNull byte[] data) {
            DataSink.DefaultImpls.writeBytes(this, data);
        }

        @Override
        public void writeVarUInt-WZ4Q5Ns(int value) {
            DataSink.DefaultImpls.writeVarUInt-WZ4Q5Ns(this, value);
        }

        @Override
        public void writeVarInt(int value) {
            DataSink.DefaultImpls.writeVarInt(this, value);
        }

        @Override
        public void writeSmartUInt-WZ4Q5Ns(int value) {
            DataSink.DefaultImpls.writeSmartUInt-WZ4Q5Ns(this, value);
        }

        @Override
        public void writeSmartInt(int value) {
            DataSink.DefaultImpls.writeSmartInt(this, value);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/sergeych/bintools/FileDataProvider$Source;", "Lnet/sergeych/bintools/DataSource;", "input", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "readByte", "", "readBytes", "", "size", "", "mp_bintools"})
    public static final class Source
    implements DataSource {
        @NotNull
        private final InputStream input;

        public Source(@NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.input = input;
        }

        @Override
        public byte readByte() {
            int b = this.input.read();
            if (b < 0) {
                throw new DataSource.EndOfData();
            }
            return (byte)b;
        }

        @Override
        @NotNull
        public byte[] readBytes(int size) {
            byte[] byArray;
            byte[] it = byArray = FileDataProviderKt.readNBytes2(this.input, size);
            boolean bl = false;
            if (it.length < size) {
                throw new DataSource.EndOfData();
            }
            return byArray;
        }

        @Override
        @Nullable
        public Boolean isEnd() {
            return DataSource.DefaultImpls.isEnd(this);
        }

        @Override
        public byte readUByte-w2LRezQ() {
            return DataSource.DefaultImpls.readUByte-w2LRezQ(this);
        }

        @Override
        public int readU32-pVg5ArA() {
            return DataSource.DefaultImpls.readU32-pVg5ArA(this);
        }

        @Override
        public int readI32() {
            return DataSource.DefaultImpls.readI32(this);
        }

        @Override
        public short readI16() {
            return DataSource.DefaultImpls.readI16(this);
        }

        @Override
        public long readI64() {
            return DataSource.DefaultImpls.readI64(this);
        }

        @Override
        public double readDouble() {
            return DataSource.DefaultImpls.readDouble(this);
        }

        @Override
        public float readFloat() {
            return DataSource.DefaultImpls.readFloat(this);
        }

        @Override
        public int readSmartUInt-pVg5ArA() {
            return DataSource.DefaultImpls.readSmartUInt-pVg5ArA(this);
        }

        @Override
        public int readSmartInt() {
            return DataSource.DefaultImpls.readSmartInt(this);
        }

        @Override
        public int readVarUInt-pVg5ArA() {
            return DataSource.DefaultImpls.readVarUInt-pVg5ArA(this);
        }

        @Override
        public int readVarInt() {
            return DataSource.DefaultImpls.readVarInt(this);
        }
    }
}

