/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010*\n\u0002\b\b\u0018\u0000 8*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00018B1\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB/\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00028\u00000\fj\b\u0012\u0004\u0012\u00028\u0000`\r\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001a\"\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\b\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010#\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010&\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010'\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010(\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010)\u001a\u00020\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0096\u0001J\u0016\u0010,\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\bH\u0096\u0003\u00a2\u0006\u0002\u0010!J\t\u0010-\u001a\u00020\u001dH\u0096\u0001J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000/H\u0096\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0096\u0001J\u0017\u00100\u001a\b\u0012\u0004\u0012\u00028\u0000012\u0006\u0010 \u001a\u00020\bH\u0096\u0001J\u001f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\bH\u0096\u0001R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u00069"}, d2={"Lnet/sergeych/collections/SortedList;", "T", "", "", "list", "", "compare", "Lkotlin/Function2;", "", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function2;)V", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/List;Ljava/util/Comparator;)V", "binarySearch", "element", "(Ljava/lang/Object;)I", "find", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "findAll", "(Ljava/lang/Object;)Ljava/util/List;", "add", "", "values", "", "([Ljava/lang/Object;)V", "remove", "", "(Ljava/lang/Object;)Z", "removeAt", "index", "(I)Ljava/lang/Object;", "indexOf", "lastIndexOf", "findFirst", "findLast", "removeAll", "contains", "addIfNotExists", "containsAll", "elements", "", "get", "isEmpty", "iterator", "", "listIterator", "", "subList", "fromIndex", "toIndex", "size", "getSize", "()I", "Companion", "mp_bintools"})
public final class SortedList<T>
implements List<T>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<T> list;
    @NotNull
    private final Function2<T, T, Integer> compare;

    public SortedList(@NotNull List<T> list, @NotNull Function2<? super T, ? super T, Integer> compare) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(compare, (String)"compare");
        this.list = list;
        this.compare = compare;
    }

    public /* synthetic */ SortedList(List list, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        this(list, function2);
    }

    public SortedList(@NotNull List<T> list, @NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this(list, (arg_0, arg_1) -> SortedList._init_$lambda$0(comparator, arg_0, arg_1));
    }

    private final int binarySearch(T element) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = this.list.get(mid);
            int cmp = ((Number)this.compare.invoke(element, midVal)).intValue();
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Nullable
    public final T find(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int i = this.binarySearch(value);
        return i < 0 ? null : (T)this.list.get(i);
    }

    @NotNull
    public final List<T> findAll(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List result = new ArrayList();
        int start = this.binarySearch(value);
        if (start >= 0) {
            T element;
            int i;
            int n = this.size();
            for (i = start; i < n && ((Number)this.compare.invoke(value, element = this.list.get(i))).intValue() == 0; ++i) {
                ((Collection)result).add(element);
            }
            if (start > 0) {
                T element2;
                for (i = start - 1; -1 < i && ((Number)this.compare.invoke(value, element2 = this.list.get(i))).intValue() == 0; --i) {
                    ((Collection)result).add(element2);
                }
            }
        }
        return result;
    }

    public final void add(T ... values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        for (T value : values) {
            int i = this.binarySearch(value);
            if (i >= 0) {
                this.list.add(i + 1, value);
                continue;
            }
            this.list.add(-(i + 1), value);
        }
    }

    @Override
    public final boolean remove(@Nullable T value) {
        boolean bl;
        if (value == null) {
            return false;
        }
        int i = this.binarySearch(value);
        if (i >= 0) {
            this.list.remove(i);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final T removeAt(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(@Nullable Object element) {
        if (element == null) {
            return -1;
        }
        int i = this.binarySearch(element);
        if (i < 0) {
            return -1;
        }
        while (i > 0 && ((Number)this.compare.invoke(element, this.list.get(i - 1))).intValue() == 0) {
            --i;
        }
        return i;
    }

    @Override
    public int lastIndexOf(@Nullable Object element) {
        if (element == null) {
            return -1;
        }
        int i = this.binarySearch(element);
        if (i < 0) {
            return -1;
        }
        while (i < this.list.size() && ((Number)this.compare.invoke(element, this.list.get(i + 1))).intValue() == 0) {
            ++i;
        }
        return i;
    }

    @Nullable
    public final T findFirst(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        int i = this.indexOf(element);
        return i < 0 ? null : (T)this.list.get(i);
    }

    @Nullable
    public final T findLast(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        int i = this.lastIndexOf(element);
        return i < 0 ? null : (T)this.list.get(i);
    }

    public final int removeAll(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int start = this.binarySearch(value);
        int count = 0;
        while (start < this.size() && ((Number)this.compare.invoke(value, this.list.get(start))).intValue() == 0) {
            this.list.remove(start);
            ++count;
        }
        while (start > 0 && ((Number)this.compare.invoke(value, this.list.get(--start))).intValue() == 0) {
            this.list.remove(start);
            ++count;
        }
        return count;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.binarySearch(element) >= 0;
    }

    public final boolean addIfNotExists(@NotNull T value) {
        boolean bl;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int i = this.binarySearch(value);
        if (i < 0) {
            this.list.add(-(i + 1), value);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.containsAll(elements);
    }

    @Override
    @NotNull
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public int getSize() {
        return this.list.size();
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    private static final int _init_$lambda$0(Comparator $comparator, Object a, Object b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return $comparator.compare(a, b);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u000e\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\t\"\u0002H\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/sergeych/collections/SortedList$Companion;", "", "<init>", "()V", "invoke", "Lnet/sergeych/collections/SortedList;", "T", "", "values", "", "([Ljava/lang/Comparable;)Lnet/sergeych/collections/SortedList;", "mp_bintools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends Comparable<? super T>> SortedList<T> invoke(T ... values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new SortedList(CollectionsKt.toMutableList((Collection)CollectionsKt.sorted((Iterable)ArraysKt.toList((Object[])values))), Companion::invoke$lambda$0);
        }

        private static final int invoke$lambda$0(Comparable a, Comparable b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.compareTo(b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

