/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.annotators;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.sergeych.lyng.Compiler;
import net.sergeych.lyng.Pos;
import net.sergeych.lyng.Script;
import net.sergeych.lyng.Source;
import net.sergeych.lyng.binding.Binder;
import net.sergeych.lyng.binding.BindingSnapshot;
import net.sergeych.lyng.binding.Reference;
import net.sergeych.lyng.binding.Symbol;
import net.sergeych.lyng.binding.SymbolKind;
import net.sergeych.lyng.highlight.HighlightKind;
import net.sergeych.lyng.highlight.HighlightSpan;
import net.sergeych.lyng.highlight.SimpleLyngHighlighter;
import net.sergeych.lyng.highlight.SimpleLyngHighlighterKt;
import net.sergeych.lyng.idea.highlight.LyngHighlighterColors;
import net.sergeych.lyng.idea.util.IdeLenientImportProvider;
import net.sergeych.lyng.miniast.MiniAstBuilder;
import net.sergeych.lyng.miniast.MiniAstSink;
import net.sergeych.lyng.miniast.MiniClassDecl;
import net.sergeych.lyng.miniast.MiniCtorField;
import net.sergeych.lyng.miniast.MiniDecl;
import net.sergeych.lyng.miniast.MiniFunDecl;
import net.sergeych.lyng.miniast.MiniFunctionType;
import net.sergeych.lyng.miniast.MiniGenericType;
import net.sergeych.lyng.miniast.MiniImport;
import net.sergeych.lyng.miniast.MiniParam;
import net.sergeych.lyng.miniast.MiniRange;
import net.sergeych.lyng.miniast.MiniScript;
import net.sergeych.lyng.miniast.MiniTypeName;
import net.sergeych.lyng.miniast.MiniTypeRef;
import net.sergeych.lyng.miniast.MiniTypeVar;
import net.sergeych.lyng.miniast.MiniValDecl;
import net.sergeych.lyng.pacman.ImportProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004\u0010\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0014"}, d2={"Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator;", "Lcom/intellij/lang/annotation/ExternalAnnotator;", "Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator$Input;", "Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator$Result;", "<init>", "()V", "collectInformation", "file", "Lcom/intellij/psi/PsiFile;", "doAnnotate", "collectedInfo", "apply", "", "annotationResult", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Input", "Span", "Result", "Companion", "lyng-idea"})
@SourceDebugExtension(value={"SMAP\nLyngExternalAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LyngExternalAnnotator.kt\nnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n808#2,11:255\n1869#2,2:266\n1869#2,2:268\n1869#2,2:270\n295#2,2:272\n1869#2,2:274\n1869#2,2:276\n1869#2,2:278\n1869#2,2:281\n1#3:280\n*S KotlinDebug\n*F\n+ 1 LyngExternalAnnotator.kt\nnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator\n*L\n109#1:255,11\n139#1:266,2\n143#1:268,2\n144#1:270,2\n173#1:272,2\n198#1:274,2\n116#1:276,2\n122#1:278,2\n126#1:281,2\n*E\n"})
public final class LyngExternalAnnotator
extends ExternalAnnotator<Input, Result> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Result> CACHE_KEY;

    @Nullable
    public Input collectInformation(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return null;
        }
        Document doc = document;
        String string = doc.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new Input(string, doc.getModificationStamp());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Result doAnnotate(@Nullable Input collectedInfo) {
        ArrayList<Span> out;
        block36: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable seg2;
            if (collectedInfo == null) {
                return null;
            }
            ProgressManager.checkCanceled();
            String text = collectedInfo.getText();
            MiniAstBuilder sink = new MiniAstBuilder();
            try {
                Source src = new Source("<ide>", text);
                IdeLenientImportProvider provider = IdeLenientImportProvider.Companion.create();
                Script cfr_ignored_0 = (Script)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Script>, Object>(src, provider, sink, null){
                    int label;
                    final /* synthetic */ Source $src;
                    final /* synthetic */ IdeLenientImportProvider $provider;
                    final /* synthetic */ MiniAstBuilder $sink;
                    {
                        this.$src = $src;
                        this.$provider = $provider;
                        this.$sink = $sink;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = Compiler.Companion.compileWithMini(this.$src, (ImportProvider)this.$provider, (MiniAstSink)this.$sink, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Script> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
            catch (Throwable e) {
                if (e instanceof ProcessCanceledException) {
                    throw e;
                }
                return new Result(collectedInfo.getModStamp(), CollectionsKt.emptyList());
            }
            ProgressManager.checkCanceled();
            MiniScript miniScript = sink.build();
            if (miniScript == null) {
                return new Result(collectedInfo.getModStamp(), CollectionsKt.emptyList());
            }
            MiniScript mini = miniScript;
            Source source = new Source("<ide>", text);
            out = new ArrayList<Span>(256);
            for (MiniDecl d : mini.getDeclarations()) {
                MiniDecl miniDecl = d;
                if (miniDecl instanceof MiniFunDecl) {
                    LyngExternalAnnotator.doAnnotate$putName(source, text, out, ((MiniFunDecl)d).getNameStart(), ((MiniFunDecl)d).getName(), LyngHighlighterColors.INSTANCE.getFUNCTION_DECLARATION());
                    continue;
                }
                if (miniDecl instanceof MiniClassDecl) {
                    LyngExternalAnnotator.doAnnotate$putName(source, text, out, ((MiniClassDecl)d).getNameStart(), ((MiniClassDecl)d).getName(), LyngHighlighterColors.INSTANCE.getTYPE());
                    continue;
                }
                if (miniDecl instanceof MiniValDecl) {
                    LyngExternalAnnotator.doAnnotate$putName(source, text, out, ((MiniValDecl)d).getNameStart(), ((MiniValDecl)d).getName(), ((MiniValDecl)d).getMutable() ? LyngHighlighterColors.INSTANCE.getVARIABLE() : LyngHighlighterColors.INSTANCE.getVALUE());
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            for (MiniImport imp : mini.getImports()) {
                for (Iterable seg2 : imp.getSegments()) {
                    LyngExternalAnnotator.doAnnotate$putMiniRange(source, text, out, seg2.getRange(), LyngHighlighterColors.INSTANCE.getNAMESPACE());
                }
            }
            Iterable $this$filterIsInstance$iv = mini.getDeclarations();
            boolean $i$f$filterIsInstance2 = false;
            seg2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MiniFunDecl)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (MiniFunDecl fn : (List)destination$iv$iv) {
                for (MiniParam p : fn.getParams()) {
                    LyngExternalAnnotator.doAnnotate$putName(source, text, out, p.getNameStart(), p.getName(), LyngHighlighterColors.INSTANCE.getPARAMETER());
                }
            }
            for (MiniDecl d : mini.getDeclarations()) {
                MiniCtorField it;
                Iterable $this$forEach$iv;
                MiniDecl $i$f$filterIsInstance2 = d;
                if ($i$f$filterIsInstance2 instanceof MiniFunDecl) {
                    LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, ((MiniFunDecl)d).getReturnType());
                    $this$forEach$iv = ((MiniFunDecl)d).getParams();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (MiniParam)element$iv;
                        boolean bl = false;
                        LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, it.getType());
                    }
                    continue;
                }
                if ($i$f$filterIsInstance2 instanceof MiniValDecl) {
                    LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, ((MiniValDecl)d).getType());
                    continue;
                }
                if ($i$f$filterIsInstance2 instanceof MiniClassDecl) {
                    $this$forEach$iv = ((MiniClassDecl)d).getCtorFields();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (MiniCtorField)element$iv;
                        boolean bl = false;
                        LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, it.getType());
                    }
                    $this$forEach$iv = ((MiniClassDecl)d).getClassFields();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (MiniCtorField)element$iv;
                        boolean bl = false;
                        LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, it.getType());
                    }
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            ProgressManager.checkCanceled();
            try {
                MiniDecl color;
                Object ref2;
                BindingSnapshot binding = Binder.INSTANCE.bind(text, mini);
                HashSet declKeys = new HashSet(binding.getSymbols().size() * 2);
                for (Object sym : binding.getSymbols()) {
                    ((Collection)declKeys).add(TuplesKt.to((Object)sym.getDeclStart(), (Object)sym.getDeclEnd()));
                }
                HashSet covered = new HashSet();
                for (Object ref2 : binding.getReferences()) {
                    Symbol sym;
                    Object v1;
                    Pair key;
                    block35: {
                        key = TuplesKt.to((Object)ref2.getStart(), (Object)ref2.getEnd());
                        if (declKeys.contains(key)) continue;
                        Iterable $this$firstOrNull$iv = binding.getSymbols();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Symbol it = (Symbol)element$iv;
                            boolean bl = false;
                            if (!(it.getId() == ref2.getSymbolId())) continue;
                            v1 = element$iv;
                            break block35;
                        }
                        v1 = null;
                    }
                    if ((Symbol)v1 == null) continue;
                    color = LyngExternalAnnotator.doAnnotate$keyForKind(sym.getKind());
                    LyngExternalAnnotator.doAnnotate$putRange(text, out, ref2.getStart(), ref2.getEnd(), (TextAttributesKey)color);
                    ((Collection)covered).add(key);
                }
                ProgressManager.checkCanceled();
                try {
                    ref2 = new SimpleLyngHighlighter().highlight(text);
                }
                catch (Throwable throwable) {
                    ref2 = CollectionsKt.emptyList();
                }
                Reference tokens = ref2;
                HashMap nameRole = new HashMap(8);
                for (MiniDecl d : mini.getDeclarations()) {
                    color = d;
                    if (color instanceof MiniValDecl) {
                        ((Map)nameRole).put(((MiniValDecl)d).getName(), ((MiniValDecl)d).getMutable() ? LyngHighlighterColors.INSTANCE.getVARIABLE() : LyngHighlighterColors.INSTANCE.getVALUE());
                        continue;
                    }
                    if (!(color instanceof MiniFunDecl)) continue;
                    Iterable $this$forEach$iv = ((MiniFunDecl)d).getParams();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        MiniParam p = (MiniParam)element$iv;
                        boolean bl = false;
                        ((Map)nameRole).put(p.getName(), LyngHighlighterColors.INSTANCE.getPARAMETER());
                    }
                }
                Iterator iterator = tokens.iterator();
                while (iterator.hasNext()) {
                    TextAttributesKey roleKey;
                    Object ident;
                    Object element$iv;
                    HighlightSpan s = (HighlightSpan)iterator.next();
                    if (s.getKind() != HighlightKind.Identifier) continue;
                    int start = s.getRange().getStart();
                    int end = s.getRange().getEndExclusive();
                    Pair key = TuplesKt.to((Object)start, (Object)end);
                    if (covered.contains(key) || declKeys.contains(key)) continue;
                    if (LyngExternalAnnotator.doAnnotate$isFollowedByParenOrBlock(text, end)) {
                        LyngExternalAnnotator.doAnnotate$putRange(text, out, start, end, LyngHighlighterColors.INSTANCE.getFUNCTION());
                        ((Collection)covered).add(key);
                        continue;
                    }
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)text.substring(start, end), (String)"substring(...)");
                    }
                    catch (Throwable throwable) {
                        element$iv = null;
                    }
                    if ((ident = element$iv) == null || (roleKey = (TextAttributesKey)nameRole.get(ident)) == null) continue;
                    LyngExternalAnnotator.doAnnotate$putRange(text, out, start, end, roleKey);
                    ((Collection)covered).add(key);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ProcessCanceledException)) break block36;
                throw e;
            }
        }
        return new Result(collectedInfo.getModStamp(), (List<Span>)out);
    }

    public void apply(@NotNull PsiFile file, @Nullable Result annotationResult, @NotNull AnnotationHolder holder) {
        Document doc;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (annotationResult == null) {
            return;
        }
        Document document = doc = file.getViewProvider().getDocument();
        Long currentStamp = document != null ? Long.valueOf(document.getModificationStamp()) : null;
        Result cached = (Result)file.getUserData(CACHE_KEY);
        Result result = cached != null && currentStamp != null && cached.getModStamp() == currentStamp.longValue() ? cached : annotationResult;
        file.putUserData(CACHE_KEY, (Object)result);
        for (Span s : result.getSpans()) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(new TextRange(s.getStart(), s.getEnd())).textAttributes(s.getKey()).create();
        }
    }

    private static final void doAnnotate$putRange(String text, ArrayList<Span> out, int start, int end, TextAttributesKey key) {
        boolean bl = 0 <= start ? start <= end : false;
        if (bl && end <= text.length() && start < end) {
            ((Collection)out).add(new Span(start, end, key));
        }
    }

    private static final void doAnnotate$putName(Source source, String text, ArrayList<Span> out, Pos startPos, String name, TextAttributesKey key) {
        int s = SimpleLyngHighlighterKt.offsetOf((Source)source, (Pos)startPos);
        LyngExternalAnnotator.doAnnotate$putRange(text, out, s, RangesKt.coerceAtMost((int)(s + name.length()), (int)text.length()), key);
    }

    private static final void doAnnotate$putMiniRange(Source source, String text, ArrayList<Span> out, MiniRange r, TextAttributesKey key) {
        int s = SimpleLyngHighlighterKt.offsetOf((Source)source, (Pos)r.getStart());
        int e = SimpleLyngHighlighterKt.offsetOf((Source)source, (Pos)r.getEnd());
        LyngExternalAnnotator.doAnnotate$putRange(text, out, s, e, key);
    }

    private static final void doAnnotate$addTypeSegments(Source source, String text, ArrayList<Span> out, MiniTypeRef t) {
        MiniTypeRef miniTypeRef = t;
        if (miniTypeRef instanceof MiniTypeName) {
            Iterable $this$forEach$iv = ((MiniTypeName)t).getSegments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MiniTypeName.Segment seg = (MiniTypeName.Segment)element$iv;
                boolean bl = false;
                int s = SimpleLyngHighlighterKt.offsetOf((Source)source, (Pos)seg.getRange().getStart());
                LyngExternalAnnotator.doAnnotate$putRange(text, out, s, RangesKt.coerceAtMost((int)(s + seg.getName().length()), (int)text.length()), LyngHighlighterColors.INSTANCE.getTYPE());
            }
        } else if (miniTypeRef instanceof MiniGenericType) {
            LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, ((MiniGenericType)t).getBase());
            Iterable $this$forEach$iv = ((MiniGenericType)t).getArgs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MiniTypeRef it = (MiniTypeRef)element$iv;
                boolean bl = false;
                LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, it);
            }
        } else if (miniTypeRef instanceof MiniFunctionType) {
            MiniTypeRef miniTypeRef2 = ((MiniFunctionType)t).getReceiver();
            if (miniTypeRef2 != null) {
                MiniTypeRef it = miniTypeRef2;
                boolean bl = false;
                LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, it);
            }
            Iterable $this$forEach$iv = ((MiniFunctionType)t).getParams();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MiniTypeRef it = (MiniTypeRef)element$iv;
                boolean bl = false;
                LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, it);
            }
            LyngExternalAnnotator.doAnnotate$addTypeSegments(source, text, out, ((MiniFunctionType)t).getReturnType());
        } else if (miniTypeRef instanceof MiniTypeVar) {
            LyngExternalAnnotator.doAnnotate$putMiniRange(source, text, out, ((MiniTypeVar)t).getRange(), LyngHighlighterColors.INSTANCE.getTYPE());
        } else if (miniTypeRef != null) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final TextAttributesKey doAnnotate$keyForKind(SymbolKind k) {
        return switch (WhenMappings.$EnumSwitchMapping$0[k.ordinal()]) {
            case 1 -> LyngHighlighterColors.INSTANCE.getFUNCTION();
            case 2, 3 -> LyngHighlighterColors.INSTANCE.getTYPE();
            case 4 -> LyngHighlighterColors.INSTANCE.getPARAMETER();
            case 5 -> LyngHighlighterColors.INSTANCE.getVALUE();
            case 6 -> LyngHighlighterColors.INSTANCE.getVARIABLE();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean doAnnotate$isFollowedByParenOrBlock(String text, int rangeEnd) {
        block3: for (int i = rangeEnd; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            return ch == '(' || ch == '{';
        }
        return false;
    }

    static {
        Key key = Key.create((String)"LYNG_SEMANTIC_CACHE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CACHE_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator$Companion;", "", "<init>", "()V", "CACHE_KEY", "Lcom/intellij/openapi/util/Key;", "Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator$Result;", "lyng-idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator$Input;", "", "text", "", "modStamp", "", "<init>", "(Ljava/lang/String;J)V", "getText", "()Ljava/lang/String;", "getModStamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "lyng-idea"})
    public static final class Input {
        @NotNull
        private final String text;
        private final long modStamp;

        public Input(@NotNull String text, long modStamp) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.modStamp = modStamp;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final long getModStamp() {
            return this.modStamp;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final long component2() {
            return this.modStamp;
        }

        @NotNull
        public final Input copy(@NotNull String text, long modStamp) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Input(text, modStamp);
        }

        public static /* synthetic */ Input copy$default(Input input, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = input.text;
            }
            if ((n & 2) != 0) {
                l = input.modStamp;
            }
            return input.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "Input(text=" + this.text + ", modStamp=" + this.modStamp + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + Long.hashCode(this.modStamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Input)) {
                return false;
            }
            Input input = (Input)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)input.text)) {
                return false;
            }
            return this.modStamp == input.modStamp;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator$Result;", "", "modStamp", "", "spans", "", "Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator$Span;", "<init>", "(JLjava/util/List;)V", "getModStamp", "()J", "getSpans", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lyng-idea"})
    public static final class Result {
        private final long modStamp;
        @NotNull
        private final List<Span> spans;

        public Result(long modStamp, @NotNull List<Span> spans) {
            Intrinsics.checkNotNullParameter(spans, (String)"spans");
            this.modStamp = modStamp;
            this.spans = spans;
        }

        public final long getModStamp() {
            return this.modStamp;
        }

        @NotNull
        public final List<Span> getSpans() {
            return this.spans;
        }

        public final long component1() {
            return this.modStamp;
        }

        @NotNull
        public final List<Span> component2() {
            return this.spans;
        }

        @NotNull
        public final Result copy(long modStamp, @NotNull List<Span> spans) {
            Intrinsics.checkNotNullParameter(spans, (String)"spans");
            return new Result(modStamp, spans);
        }

        public static /* synthetic */ Result copy$default(Result result, long l, List list, int n, Object object) {
            if ((n & 1) != 0) {
                l = result.modStamp;
            }
            if ((n & 2) != 0) {
                list = result.spans;
            }
            return result.copy(l, list);
        }

        @NotNull
        public String toString() {
            return "Result(modStamp=" + this.modStamp + ", spans=" + this.spans + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.modStamp);
            result = result * 31 + ((Object)this.spans).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (this.modStamp != result.modStamp) {
                return false;
            }
            return Intrinsics.areEqual(this.spans, result.spans);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lnet/sergeych/lyng/idea/annotators/LyngExternalAnnotator$Span;", "", "start", "", "end", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "<init>", "(IILcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "getStart", "()I", "getEnd", "getKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "lyng-idea"})
    public static final class Span {
        private final int start;
        private final int end;
        @NotNull
        private final TextAttributesKey key;

        public Span(int start, int end, @NotNull TextAttributesKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.start = start;
            this.end = end;
            this.key = key;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final TextAttributesKey getKey() {
            return this.key;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final TextAttributesKey component3() {
            return this.key;
        }

        @NotNull
        public final Span copy(int start, int end, @NotNull TextAttributesKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new Span(start, end, key);
        }

        public static /* synthetic */ Span copy$default(Span span, int n, int n2, TextAttributesKey textAttributesKey, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = span.start;
            }
            if ((n3 & 2) != 0) {
                n2 = span.end;
            }
            if ((n3 & 4) != 0) {
                textAttributesKey = span.key;
            }
            return span.copy(n, n2, textAttributesKey);
        }

        @NotNull
        public String toString() {
            return "Span(start=" + this.start + ", end=" + this.end + ", key=" + this.key + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + this.key.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Span)) {
                return false;
            }
            Span span = (Span)other;
            if (this.start != span.start) {
                return false;
            }
            if (this.end != span.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.key, (Object)span.key);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SymbolKind.values().length];
            try {
                nArray[SymbolKind.Function.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SymbolKind.Class.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SymbolKind.Enum.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SymbolKind.Param.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SymbolKind.Val.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SymbolKind.Var.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

