/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.docs;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.sergeych.lyng.Compiler;
import net.sergeych.lyng.Pos;
import net.sergeych.lyng.Script;
import net.sergeych.lyng.Source;
import net.sergeych.lyng.highlight.SimpleLyngHighlighterKt;
import net.sergeych.lyng.idea.LyngLanguage;
import net.sergeych.lyng.idea.util.IdeLenientImportProvider;
import net.sergeych.lyng.miniast.MiniAstBuilder;
import net.sergeych.lyng.miniast.MiniAstSink;
import net.sergeych.lyng.miniast.MiniClassDecl;
import net.sergeych.lyng.miniast.MiniDecl;
import net.sergeych.lyng.miniast.MiniFunDecl;
import net.sergeych.lyng.miniast.MiniFunctionType;
import net.sergeych.lyng.miniast.MiniGenericType;
import net.sergeych.lyng.miniast.MiniParam;
import net.sergeych.lyng.miniast.MiniScript;
import net.sergeych.lyng.miniast.MiniTypeName;
import net.sergeych.lyng.miniast.MiniTypeRef;
import net.sergeych.lyng.miniast.MiniTypeVar;
import net.sergeych.lyng.miniast.MiniValDecl;
import net.sergeych.lyng.pacman.ImportProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J,\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0013H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lnet/sergeych/lyng/idea/docs/LyngDocumentationProvider;", "Lcom/intellij/lang/documentation/AbstractDocumentationProvider;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "generateDoc", "", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "getCustomDocumentationElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "contextElement", "targetOffset", "", "renderDeclDoc", "d", "Lnet/sergeych/lyng/miniast/MiniDecl;", "renderParamDoc", "fn", "Lnet/sergeych/lyng/miniast/MiniFunDecl;", "p", "Lnet/sergeych/lyng/miniast/MiniParam;", "typeOf", "t", "Lnet/sergeych/lyng/miniast/MiniTypeRef;", "signatureOf", "htmlEscape", "s", "wordRangeAt", "Lcom/intellij/openapi/util/TextRange;", "text", "offset", "isIdentChar", "", "c", "", "lyng-idea"})
@SourceDebugExtension(value={"SMAP\nLyngDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LyngDocumentationProvider.kt\nnet/sergeych/lyng/idea/docs/LyngDocumentationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n808#2,11:175\n295#2,2:186\n1#3:188\n*S KotlinDebug\n*F\n+ 1 LyngDocumentationProvider.kt\nnet/sergeych/lyng/idea/docs/LyngDocumentationProvider\n*L\n83#1:175,11\n94#1:186,2\n*E\n"})
public final class LyngDocumentationProvider
extends AbstractDocumentationProvider {
    @NotNull
    private final Logger log;

    public LyngDocumentationProvider() {
        Logger logger = Logger.getInstance(LyngDocumentationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String generateDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        Object v9;
        String ident;
        block14: {
            void $this$filterIsInstanceTo$iv$iv;
            if (element == null) {
                return null;
            }
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            PsiFile file = psiFile;
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                return null;
            }
            Document document2 = document;
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text = string;
            PsiElement psiElement = originalElement;
            int offset = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : element.getTextRange().getStartOffset();
            TextRange textRange = this.wordRangeAt(text, offset);
            if (textRange == null) {
                LyngDocumentationProvider $this$generateDoc_u24lambda_u240 = this;
                boolean bl = false;
                $this$generateDoc_u24lambda_u240.log.info("[LYNG_DEBUG] QuickDoc: no word at offset=" + offset + " in " + file.getName());
                return null;
            }
            TextRange idRange = textRange;
            if (idRange.isEmpty()) {
                return null;
            }
            String string2 = text.substring(idRange.getStartOffset(), idRange.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            ident = string2;
            this.log.info("[LYNG_DEBUG] QuickDoc: ident='" + ident + "' at " + idRange.getStartOffset() + ".." + idRange.getEndOffset() + " in " + file.getName());
            MiniAstBuilder sink = new MiniAstBuilder();
            try {
                Source src = new Source("<ide>", text);
                IdeLenientImportProvider provider = IdeLenientImportProvider.Companion.create();
                Script cfr_ignored_0 = (Script)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Script>, Object>(src, provider, sink, null){
                    int label;
                    final /* synthetic */ Source $src;
                    final /* synthetic */ IdeLenientImportProvider $provider;
                    final /* synthetic */ MiniAstBuilder $sink;
                    {
                        this.$src = $src;
                        this.$provider = $provider;
                        this.$sink = $sink;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = Compiler.Companion.compileWithMini(this.$src, (ImportProvider)this.$provider, (MiniAstSink)this.$sink, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Script> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
            catch (Throwable t) {
                this.log.warn("[LYNG_DEBUG] QuickDoc: compileWithMini failed: " + t.getMessage());
                return null;
            }
            MiniScript miniScript = sink.build();
            if (miniScript == null) {
                return null;
            }
            MiniScript mini = miniScript;
            Source source = new Source("<ide>", text);
            for (MiniDecl d : mini.getDeclarations()) {
                int s = SimpleLyngHighlighterKt.offsetOf((Source)source, (Pos)d.getNameStart());
                int e = RangesKt.coerceAtMost((int)(s + d.getName().length()), (int)text.length());
                boolean bl = s <= offset ? offset < e : false;
                if (!bl) continue;
                this.log.info("[LYNG_DEBUG] QuickDoc: matched decl '" + d.getName() + "' kind=" + Reflection.getOrCreateKotlinClass(d.getClass()).getSimpleName());
                return this.renderDeclDoc(d);
            }
            Iterable $this$filterIsInstance$iv = mini.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable e = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MiniFunDecl)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (MiniFunDecl fn : (List)destination$iv$iv) {
                for (MiniParam p : fn.getParams()) {
                    int s = SimpleLyngHighlighterKt.offsetOf((Source)source, (Pos)p.getNameStart());
                    int e2 = RangesKt.coerceAtMost((int)(s + p.getName().length()), (int)text.length());
                    boolean bl = s <= offset ? offset < e2 : false;
                    if (!bl) continue;
                    this.log.info("[LYNG_DEBUG] QuickDoc: matched param '" + p.getName() + "' in fun '" + fn.getName() + "'");
                    return this.renderParamDoc(fn, p);
                }
            }
            Iterable $this$firstOrNull$iv = mini.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MiniDecl it = (MiniDecl)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)ident)) continue;
                v9 = element$iv;
                break block14;
            }
            v9 = null;
        }
        MiniDecl miniDecl = v9;
        if (miniDecl != null) {
            MiniDecl it = miniDecl;
            boolean bl = false;
            this.log.info("[LYNG_DEBUG] QuickDoc: fallback by name '" + it.getName() + "' kind=" + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName());
            return this.renderDeclDoc(it);
        }
        this.log.info("[LYNG_DEBUG] QuickDoc: nothing found for ident='" + ident + "'");
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)LyngLanguage.INSTANCE))) {
            return null;
        }
        PsiElement psiElement = contextElement;
        if (psiElement == null) {
            psiElement = file.findElementAt(targetOffset);
        }
        return psiElement;
    }

    private final String renderDeclDoc(MiniDecl d) {
        String string;
        Object title;
        MiniDecl miniDecl = d;
        Object object = miniDecl instanceof MiniFunDecl ? "function " + ((MiniFunDecl)d).getName() + this.signatureOf((MiniFunDecl)d) : (miniDecl instanceof MiniClassDecl ? "class " + ((MiniClassDecl)d).getName() : (miniDecl instanceof MiniValDecl ? (((MiniValDecl)d).getMutable() ? "var " + ((MiniValDecl)d).getName() + this.typeOf(((MiniValDecl)d).getType()) : "val " + ((MiniValDecl)d).getName() + this.typeOf(((MiniValDecl)d).getType())) : (title = d.getName())));
        Object object2 = d.getDoc();
        if (object2 != null && (object2 = object2.getRaw()) != null) {
            Object it = object2;
            boolean bl = false;
            string = StringsKt.replace$default((String)this.htmlEscape((String)it), (String)"\n", (String)"<br/>", (boolean)false, (int)4, null);
        } else {
            string = null;
        }
        String doc = string;
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='doc-title'>").append(this.htmlEscape((String)title)).append("</div>");
        CharSequence charSequence = doc;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sb.append("<div class='doc-body'>").append(doc).append("</div>");
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String renderParamDoc(MiniFunDecl fn, MiniParam p) {
        String title = "parameter " + p.getName() + this.typeOf(p.getType()) + " in " + fn.getName() + this.signatureOf(fn);
        return "<div class='doc-title'>" + this.htmlEscape(title) + "</div>";
    }

    private final String typeOf(MiniTypeRef t) {
        Object object;
        MiniTypeRef miniTypeRef = t;
        if (miniTypeRef instanceof MiniTypeName) {
            object = ": " + CollectionsKt.joinToString$default((Iterable)((MiniTypeName)t).getSegments(), (CharSequence)".", null, null, (int)0, null, LyngDocumentationProvider::typeOf$lambda$0, (int)30, null);
        } else if (miniTypeRef instanceof MiniGenericType) {
            object = ": " + StringsKt.removePrefix((String)this.typeOf(((MiniGenericType)t).getBase()), (CharSequence)": ") + "<" + CollectionsKt.joinToString$default((Iterable)((MiniGenericType)t).getArgs(), (CharSequence)", ", null, null, (int)0, null, arg_0 -> LyngDocumentationProvider.typeOf$lambda$1(this, arg_0), (int)30, null) + ">";
        } else if (miniTypeRef instanceof MiniFunctionType) {
            object = ": (..) -> ..";
        } else if (miniTypeRef instanceof MiniTypeVar) {
            object = ": " + ((MiniTypeVar)t).getName();
        } else if (miniTypeRef == null) {
            object = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final String signatureOf(MiniFunDecl fn) {
        String params = CollectionsKt.joinToString$default((Iterable)fn.getParams(), (CharSequence)", ", null, null, (int)0, null, arg_0 -> LyngDocumentationProvider.signatureOf$lambda$0(this, arg_0), (int)30, null);
        String ret = this.typeOf(fn.getReturnType());
        return "(" + params + ")" + ret;
    }

    private final String htmlEscape(String s) {
        StringBuilder stringBuilder;
        int n = s.length();
        StringBuilder $this$htmlEscape_u24lambda_u240 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int n2 = s.length();
        for (int i = 0; i < n2; ++i) {
            char ch = s.charAt(i);
            $this$htmlEscape_u24lambda_u240.append(switch (ch) {
                case '<' -> "&lt;";
                case '>' -> "&gt;";
                case '&' -> "&amp;";
                case '\"' -> "&quot;";
                default -> Character.valueOf(ch);
            });
        }
        return stringBuilder.toString();
    }

    private final TextRange wordRangeAt(String text, int offset) {
        int s;
        if (((CharSequence)text).length() == 0) {
            return null;
        }
        int e = s = RangesKt.coerceIn((int)offset, (int)0, (int)text.length());
        while (s > 0 && this.isIdentChar(text.charAt(s - 1))) {
            --s;
        }
        while (e < text.length() && this.isIdentChar(text.charAt(e))) {
            ++e;
        }
        return e > s ? new TextRange(s, e) : null;
    }

    private final boolean isIdentChar(char c) {
        return c == '_' || Character.isLetterOrDigit(c);
    }

    private static final CharSequence typeOf$lambda$0(MiniTypeName.Segment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence typeOf$lambda$1(LyngDocumentationProvider this$0, MiniTypeRef it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.removePrefix((String)this$0.typeOf(it), (CharSequence)": ");
    }

    private static final CharSequence signatureOf$lambda$0(LyngDocumentationProvider this$0, MiniParam p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String ts = this$0.typeOf(p.getType());
        return !StringsKt.isBlank((CharSequence)ts) ? (CharSequence)(p.getName() + ts) : (CharSequence)p.getName();
    }
}

