/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.sergeych.lyng.format.BraceUtils;
import net.sergeych.lyng.format.LyngFormatConfig;
import net.sergeych.lyng.format.LyngFormatter;
import net.sergeych.lyng.idea.LyngLanguage;
import net.sergeych.lyng.idea.settings.LyngFormatterSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J \u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J(\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J0\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u000fH\u0002J \u0010%\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0014\u0010(\u001a\u00020\u000f*\u00020\u001b2\u0006\u0010)\u001a\u00020\u000fH\u0002J\u0014\u0010*\u001a\u00020$*\u00020\u001b2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0014\u0010+\u001a\u00020\u000f*\u00020\u001b2\u0006\u0010 \u001a\u00020\u000fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/sergeych/lyng/idea/editor/LyngEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "postProcessEnter", "adjustBraceAndCurrentIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "doc", "Lcom/intellij/openapi/editor/Document;", "currentLine", "reindentClosedBlockAroundBrace", "braceLine", "moveCaretToIndentIfOnLeadingWs", "line", "caret", "Lcom/intellij/openapi/editor/Caret;", "computeDesiredIndent", "", "findFirstNonWs", "start", "end", "safeLineNumber", "offset", "getLineText", "getLineStartOffsetSafe", "lyng-idea"})
@SourceDebugExtension(value={"SMAP\nLyngEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LyngEnterHandler.kt\nnet/sergeych/lyng/idea/editor/LyngEnterHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n158#2,6:209\n1#3:215\n*S KotlinDebug\n*F\n+ 1 LyngEnterHandler.kt\nnet/sergeych/lyng/idea/editor/LyngEnterHandler\n*L\n180#1:209,6\n*E\n"})
public final class LyngEnterHandler
implements EnterHandlerDelegate {
    @NotNull
    private final Logger log;

    public LyngEnterHandler() {
        Logger logger = Logger.getInstance(LyngEnterHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)LyngLanguage.INSTANCE))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("[LyngEnter] preprocess in Lyng file at caretOffset=" + caretOffset.get());
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)LyngLanguage.INSTANCE))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance((Project)project2);
        psiManager.commitDocument(doc);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            int line = this.safeLineNumber(doc, caret.getOffset());
            if (line < 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("[LyngEnter] postProcess at line=" + line + " offset=" + caret.getOffset());
            }
            this.adjustBraceAndCurrentIndent(project2, file, doc, line);
            Intrinsics.checkNotNull((Object)caret);
            this.moveCaretToIndentIfOnLeadingWs(editor, doc, file, line, caret);
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private final void adjustBraceAndCurrentIndent(Project project, PsiFile file, Document doc, int currentLine) {
        int replaceTo;
        int replaceFrom;
        LyngFormatterSettings settings;
        String prevText;
        String trimmed;
        String code;
        int prevLine = currentLine - 1;
        if (prevLine >= 0 && Intrinsics.areEqual((Object)(code = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)(trimmed = ((Object)StringsKt.trimStart((CharSequence)(prevText = this.getLineText(doc, prevLine)))).toString()), (String)"//", null, (int)2, null))).toString()), (Object)"}") && (settings = LyngFormatterSettings.Companion.getInstance(project)).getReindentClosedBlockOnEnter()) {
            this.reindentClosedBlockAroundBrace(project, file, doc, prevLine);
        }
        int currentStart = this.getLineStartOffsetSafe(doc, currentLine);
        CodeStyleManager csm = CodeStyleManager.getInstance((Project)project);
        csm.adjustLineIndent(file, currentStart);
        int lineStart = doc.getLineStartOffset(currentLine);
        int lineEnd = doc.getLineEndOffset(currentLine);
        String desiredIndent = this.computeDesiredIndent(project, doc, currentLine);
        int firstNonWs = this.findFirstNonWs(doc, lineStart, lineEnd);
        int currentIndentLen = firstNonWs - lineStart;
        if ((((CharSequence)desiredIndent).length() > 0 || currentIndentLen != 0) && !Intrinsics.areEqual((Object)doc.getText(new TextRange(replaceFrom = lineStart, replaceTo = lineStart + currentIndentLen)), (Object)desiredIndent)) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> LyngEnterHandler.adjustBraceAndCurrentIndent$lambda$0(doc, replaceFrom, replaceTo, desiredIndent));
            PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
            if (this.log.isDebugEnabled()) {
                String dbg = StringsKt.replace$default((String)desiredIndent, (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
                this.log.debug("[LyngEnter] rewrote current line leading WS to '" + dbg + "' at line=" + currentLine);
            }
        }
    }

    private final void reindentClosedBlockAroundBrace(Project project, PsiFile file, Document doc, int braceLine) {
        int braceLineStart = doc.getLineStartOffset(braceLine);
        int braceLineEnd = doc.getLineEndOffset(braceLine);
        String string = doc.getText(new TextRange(braceLineStart, braceLineEnd));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String rawBraceLine = string;
        String codeBraceLine = StringsKt.substringBefore$default((String)rawBraceLine, (String)"//", null, (int)2, null);
        int closeRel = StringsKt.lastIndexOf$default((CharSequence)codeBraceLine, (char)'}', (int)0, (boolean)false, (int)6, null);
        if (closeRel < 0) {
            return;
        }
        int closeAbs = braceLineStart + closeRel;
        CharSequence charSequence = doc.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        IntRange intRange = BraceUtils.INSTANCE.findEnclosingBlockRange(charSequence, closeAbs, true);
        if (intRange == null) {
            return;
        }
        IntRange blockRange = intRange;
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((Project)project, (Document)doc);
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions options = indentOptions;
        LyngFormatConfig cfg = new LyngFormatConfig(RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1), options.USE_TAB_CHARACTER, RangesKt.coerceAtLeast((int)options.CONTINUATION_INDENT_SIZE, (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1)), 0, false, false, false, 120, null);
        String string2 = doc.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String whole = string2;
        String updated = LyngFormatter.reindentRange$default((LyngFormatter)LyngFormatter.INSTANCE, (String)whole, (IntRange)blockRange, (LyngFormatConfig)cfg, (boolean)true, null, (int)16, null);
        if (!Intrinsics.areEqual((Object)updated, (Object)whole)) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> LyngEnterHandler.reindentClosedBlockAroundBrace$lambda$0(doc, updated));
            PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
            if (this.log.isDebugEnabled()) {
                this.log.debug("[LyngEnter] reindented closed block range=$blockRange");
            }
        }
    }

    private final void moveCaretToIndentIfOnLeadingWs(Editor editor, Document doc, PsiFile file, int line, Caret caret) {
        if (line < 0 || line >= doc.getLineCount()) {
            return;
        }
        int lineStart = doc.getLineStartOffset(line);
        int lineEnd = doc.getLineEndOffset(line);
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String desiredIndent = this.computeDesiredIndent(project, doc, line);
        int firstNonWs = RangesKt.coerceAtMost((int)(lineStart + desiredIndent.length()), (int)doc.getTextLength());
        int caretOffset = caret.getOffset();
        int target = RangesKt.coerceIn((int)firstNonWs, (int)lineStart, (int)lineEnd);
        caret.moveToOffset(target);
    }

    private final String computeDesiredIndent(Project project, Document doc, int line) {
        int n;
        String lastLine;
        block3: {
            String string;
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((Project)project, (Document)doc);
            Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
            CommonCodeStyleSettings.IndentOptions options = indentOptions;
            int start = 0;
            int end = doc.getLineEndOffset(line);
            String string2 = doc.getText(new TextRange(start, end));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String snippet = string2;
            boolean isBlankLine = ((CharSequence)((Object)StringsKt.trim((CharSequence)this.getLineText(doc, line))).toString()).length() == 0;
            Object snippetForCalc = isBlankLine ? snippet + "x" : snippet;
            LyngFormatConfig cfg = new LyngFormatConfig(RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1), options.USE_TAB_CHARACTER, RangesKt.coerceAtLeast((int)options.CONTINUATION_INDENT_SIZE, (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1)), 0, false, false, false, 120, null);
            String formatted = LyngFormatter.INSTANCE.reindent((String)snippetForCalc, cfg);
            int lastNl = StringsKt.lastIndexOf$default((CharSequence)formatted, (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (lastNl >= 0) {
                String string3 = formatted.substring(lastNl + 1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = formatted;
            }
            lastLine = string;
            CharSequence $this$indexOfFirst$iv = lastLine;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != ' ' && it != '\t')) continue;
                n = index$iv;
                break block3;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        int wsLen = it < 0 ? lastLine.length() : it;
        String string = lastLine.substring(0, wsLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final int findFirstNonWs(Document doc, int start, int end) {
        char ch;
        int i;
        CharSequence charSequence = doc.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text = charSequence;
        for (i = start; i < end && ((ch = text.charAt(i)) == ' ' || ch == '\t'); ++i) {
        }
        return i;
    }

    private final int safeLineNumber(Document $this$safeLineNumber, int offset) {
        return $this$safeLineNumber.getLineNumber(RangesKt.coerceIn((int)offset, (int)0, (int)$this$safeLineNumber.getTextLength()));
    }

    private final String getLineText(Document $this$getLineText, int line) {
        if (line < 0 || line >= $this$getLineText.getLineCount()) {
            return "";
        }
        int start = $this$getLineText.getLineStartOffset(line);
        int end = $this$getLineText.getLineEndOffset(line);
        String string = $this$getLineText.getText(new TextRange(start, end));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final int getLineStartOffsetSafe(Document $this$getLineStartOffsetSafe, int line) {
        return line < 0 ? 0 : $this$getLineStartOffsetSafe.getLineStartOffset(RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)line, (int)($this$getLineStartOffsetSafe.getLineCount() - 1)), (int)0));
    }

    private static final void adjustBraceAndCurrentIndent$lambda$0(Document $doc, int $replaceFrom, int $replaceTo, String $desiredIndent) {
        $doc.replaceString($replaceFrom, $replaceTo, (CharSequence)$desiredIndent);
    }

    private static final void reindentClosedBlockAroundBrace$lambda$0(Document $doc, String $updated) {
        $doc.replaceString(0, $doc.getTextLength(), (CharSequence)$updated);
    }
}

