/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.awt.datatransfer.DataFlavor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.sergeych.lyng.format.LyngFormatConfig;
import net.sergeych.lyng.format.LyngFormatter;
import net.sergeych.lyng.idea.LyngLanguage;
import net.sergeych.lyng.idea.settings.LyngFormatterSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/sergeych/lyng/idea/editor/LyngPasteHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "pasteAsIs", "pasteText", "text", "", "lyng-idea"})
public final class LyngPasteHandler
extends EditorWriteActionHandler {
    @NotNull
    private final Logger log;

    public LyngPasteHandler() {
        super(true);
        Logger logger = Logger.getInstance(LyngPasteHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager psiDocMgr = PsiDocumentManager.getInstance((Project)project);
        PsiFile file = psiDocMgr.getPsiFile(editor.getDocument());
        if (file == null || !Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)LyngLanguage.INSTANCE))) {
            this.pasteAsIs(editor);
            return;
        }
        LyngFormatterSettings settings = LyngFormatterSettings.Companion.getInstance(project);
        if (!settings.getReindentPastedBlocks()) {
            this.pasteAsIs(editor);
            return;
        }
        String text = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        if (text == null) {
            this.pasteAsIs(editor);
            return;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        Caret caret2 = caret;
        if (caret2 == null) {
            Caret caret3 = caretModel2.getCurrentCaret();
            caret2 = caret3;
            Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"getCurrentCaret(...)");
        }
        Caret effectiveCaret = caret2;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((Project)project, (Document)doc);
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions options = indentOptions;
        LyngFormatConfig cfg = new LyngFormatConfig(RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1), options.USE_TAB_CHARACTER, RangesKt.coerceAtLeast((int)options.CONTINUATION_INDENT_SIZE, (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1)), 0, false, false, false, 120, null);
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selModel = selectionModel;
        int replaceStart = selModel.hasSelection() ? selModel.getSelectionStart() : effectiveCaret.getOffset();
        int replaceEnd = selModel.hasSelection() ? selModel.getSelectionEnd() : effectiveCaret.getOffset();
        WriteCommandAction.runWriteCommandAction((Project)project, () -> LyngPasteHandler.doExecute$lambda$0(this, settings, doc, replaceStart, replaceEnd, text, psiDocMgr, cfg, caretModel2, selModel));
    }

    private final void pasteAsIs(Editor editor) {
        String string = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        if (string == null) {
            return;
        }
        String text = string;
        this.pasteText(editor, text);
    }

    private final void pasteText(Editor editor, String text) {
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selModel = selectionModel;
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> LyngPasteHandler.pasteText$lambda$0(selModel, caretModel2, doc, text, project2));
    }

    private static final void doExecute$lambda$0(LyngPasteHandler this$0, LyngFormatterSettings $settings, Document $doc, int $replaceStart, int $replaceEnd, String $text, PsiDocumentManager $psiDocMgr, LyngFormatConfig $cfg, CaretModel $caretModel, SelectionModel $selModel) {
        int j;
        int i;
        int i2;
        this$0.log.info("[LyngPaste] handler invoked for Lyng file; setting ON=" + $settings.getReindentPastedBlocks());
        int beforeLen = $doc.getTextLength();
        $doc.replaceString($replaceStart, $replaceEnd, (CharSequence)$text);
        $psiDocMgr.commitDocument($doc);
        int insertedStart = $replaceStart;
        int delta = $doc.getTextLength() - beforeLen + ($replaceEnd - $replaceStart);
        int insertedEndExclusive = RangesKt.coerceIn((int)(insertedStart + delta), (int)insertedStart, (int)$doc.getTextLength());
        LyngPasteHandler $this$doExecute_u24lambda_u240_u240 = this$0;
        boolean bl = false;
        for (i2 = RangesKt.coerceAtLeast((int)(insertedStart - 1), (int)0); i2 >= 0 && $doc.getCharsSequence().charAt(i2) != '\n'; --i2) {
        }
        int lineStart = i2 + 1;
        int lineEndInclusive = 0;
        LyngPasteHandler $this$doExecute_u24lambda_u240_u241 = this$0;
        boolean bl2 = false;
        CharSequence charSequence = $doc.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence seq = charSequence;
        for (i = insertedEndExclusive; i < seq.length() && seq.charAt(i) != '\n'; ++i) {
        }
        lineEndInclusive = i < seq.length() && seq.charAt(i) == '\n' ? i + 1 : i;
        LyngPasteHandler $this$doExecute_u24lambda_u240_u242 = this$0;
        boolean bl3 = false;
        CharSequence charSequence2 = $doc.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getCharsSequence(...)");
        CharSequence seq2 = charSequence2;
        for (j = insertedEndExclusive; j < seq2.length() && (seq2.charAt(j) == ' ' || seq2.charAt(j) == '\t' || seq2.charAt(j) == '\n' || seq2.charAt(j) == '\r'); ++j) {
        }
        if (j < seq2.length() && seq2.charAt(j) == '}') {
            int k;
            for (k = j; k < seq2.length() && seq2.charAt(k) != '\n'; ++k) {
            }
            lineEndInclusive = k < seq2.length() && seq2.charAt(k) == '\n' ? k + 1 : k;
        }
        String string = $doc.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String fullTextBefore = string;
        IntRange expandedRange = RangesKt.until((int)lineStart, (int)lineEndInclusive);
        this$0.log.info("[LyngPaste] inserted=[" + insertedStart + "," + insertedEndExclusive + ") expanded=[" + lineStart + "," + lineEndInclusive + ")");
        String updatedFull = LyngFormatter.INSTANCE.reindentRange(fullTextBefore, expandedRange, $cfg, true, Integer.valueOf(insertedStart));
        if (!Intrinsics.areEqual((Object)updatedFull, (Object)fullTextBefore)) {
            int delta2 = updatedFull.length() - fullTextBefore.length();
            $doc.replaceString(0, $doc.getTextLength(), (CharSequence)updatedFull);
            $psiDocMgr.commitDocument($doc);
            $caretModel.moveToOffset(RangesKt.coerceIn((int)(insertedEndExclusive + delta2), (int)0, (int)$doc.getTextLength()));
            this$0.log.info("[LyngPaste] applied reindent to expanded range");
        } else {
            $caretModel.moveToOffset(insertedEndExclusive);
            this$0.log.info("[LyngPaste] no changes after reindent");
        }
        $selModel.removeSelection();
    }

    private static final void pasteText$lambda$0(SelectionModel $selModel, CaretModel $caretModel, Document $doc, String $text, Project $project) {
        int replaceStart = $selModel.hasSelection() ? $selModel.getSelectionStart() : $caretModel.getOffset();
        int replaceEnd = $selModel.hasSelection() ? $selModel.getSelectionEnd() : $caretModel.getOffset();
        $doc.replaceString(replaceStart, replaceEnd, (CharSequence)$text);
        PsiDocumentManager.getInstance((Project)$project).commitDocument($doc);
        $caretModel.moveToOffset(replaceStart + $text.length());
        $selModel.removeSelection();
    }
}

