/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.sergeych.lyng.format.LyngFormatConfig;
import net.sergeych.lyng.format.LyngFormatter;
import net.sergeych.lyng.idea.LyngLanguage;
import net.sergeych.lyng.idea.settings.LyngFormatterSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Lnet/sergeych/lyng/idea/editor/LyngPastePreProcessor;", "", "<init>", "()V", "reindentForPaste", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "text", "firstNonWhitespace", "", "doc", "Lcom/intellij/openapi/editor/Document;", "from", "to", "lyng-idea"})
public final class LyngPastePreProcessor {
    @NotNull
    public static final LyngPastePreProcessor INSTANCE = new LyngPastePreProcessor();

    private LyngPastePreProcessor() {
    }

    @NotNull
    public final String reindentForPaste(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)LyngLanguage.INSTANCE))) {
            return text;
        }
        LyngFormatterSettings settings = LyngFormatterSettings.Companion.getInstance(project);
        if (!settings.getReindentPastedBlocks()) {
            return text;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((Project)project, (Document)doc);
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions options = indentOptions;
        LyngFormatConfig cfg = new LyngFormatConfig(RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1), options.USE_TAB_CHARACTER, RangesKt.coerceAtLeast((int)options.CONTINUATION_INDENT_SIZE, (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1)), 0, false, false, false, 120, null);
        Caret caret = editor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        Caret caret2 = caret;
        int line = doc.getLineNumber(RangesKt.coerceIn((int)caret2.getOffset(), (int)0, (int)doc.getTextLength()));
        if (line < 0 || line >= doc.getLineCount()) {
            return text;
        }
        int lineStart = doc.getLineStartOffset(line);
        int firstNonWs = this.firstNonWhitespace(doc, lineStart, doc.getLineEndOffset(line));
        if (caret2.getOffset() > firstNonWs) {
            return text;
        }
        String baseIndent = ((Object)doc.getCharsSequence().subSequence(lineStart, caret2.getOffset())).toString();
        String reindented = LyngFormatter.INSTANCE.reindent(text, cfg);
        char[] cArray = new char[]{'\n'};
        List lines = StringsKt.split$default((CharSequence)reindented, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        StringBuilder sb = new StringBuilder(reindented.length() + lines.size() * baseIndent.length());
        Iterator iterator = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            String ln = (String)iterator.next();
            StringBuilder stringBuilder = ((CharSequence)ln).length() > 0 ? sb.append(baseIndent).append(ln) : sb.append(ln);
            if (idx >= CollectionsKt.getLastIndex((List)lines)) continue;
            sb.append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final int firstNonWhitespace(Document doc, int from, int to) {
        char ch;
        int i;
        CharSequence charSequence = doc.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence seq = charSequence;
        for (i = from; i < to && ((ch = seq.charAt(i)) == ' ' || ch == '\t'); ++i) {
        }
        return i;
    }
}

