/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.editor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.sergeych.lyng.idea.LyngLanguage;
import net.sergeych.lyng.idea.editor.LyngPastePreProcessor;
import net.sergeych.lyng.idea.settings.LyngFormatterSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lnet/sergeych/lyng/idea/editor/LyngSmartPastePreProcessorHelper;", "", "<init>", "()V", "processOnPasteIfEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "lyng-idea"})
public final class LyngSmartPastePreProcessorHelper {
    @NotNull
    public static final LyngSmartPastePreProcessorHelper INSTANCE = new LyngSmartPastePreProcessorHelper();

    private LyngSmartPastePreProcessorHelper() {
    }

    @NotNull
    public final String processOnPasteIfEnabled(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)LyngLanguage.INSTANCE))) {
            return text;
        }
        LyngFormatterSettings settings = LyngFormatterSettings.Companion.getInstance(project);
        if (!settings.getReindentPastedBlocks()) {
            return text;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        return LyngPastePreProcessor.INSTANCE.reindentForPaste(project, editor, file, text);
    }
}

