/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.format;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.sergeych.lyng.format.LyngFormatConfig;
import net.sergeych.lyng.format.LyngFormatter;
import net.sergeych.lyng.idea.LyngLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\u0010\u001a\u00020\r*\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0012\u001a\u00020\u0005*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001c"}, d2={"Lnet/sergeych/lyng/idea/format/LyngLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "<init>", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "isSuitableFor", "", "getLineNumberSafe", "Lcom/intellij/openapi/editor/Document;", "getLineText", "line", "indentUnit", "options", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "indentOfLine", "doc", "countIndentUnits", "indent", "computeDesiredIndentFromCore", "lyng-idea"})
@SourceDebugExtension(value={"SMAP\nLyngLineIndentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LyngLineIndentProvider.kt\nnet/sergeych/lyng/idea/format/LyngLineIndentProvider\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n158#2,6:105\n648#2,5:111\n1104#2,3:116\n158#2,6:119\n1#3:125\n*S KotlinDebug\n*F\n+ 1 LyngLineIndentProvider.kt\nnet/sergeych/lyng/idea/format/LyngLineIndentProvider\n*L\n69#1:105,6\n70#1:111,5\n75#1:116,3\n100#1:119,6\n*E\n"})
public final class LyngLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (language != null && !Intrinsics.areEqual((Object)language, (Object)((Object)LyngLanguage.INSTANCE))) {
            return null;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((Project)project, (Document)doc);
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions options = indentOptions;
        int line = this.getLineNumberSafe(doc, offset);
        String indent = this.computeDesiredIndentFromCore(doc, line, options);
        return indent;
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language == null || Intrinsics.areEqual((Object)language, (Object)((Object)LyngLanguage.INSTANCE));
    }

    private final int getLineNumberSafe(Document $this$getLineNumberSafe, int offset) {
        return $this$getLineNumberSafe.getLineNumber(RangesKt.coerceIn((int)offset, (int)0, (int)$this$getLineNumberSafe.getTextLength()));
    }

    private final String getLineText(Document $this$getLineText, int line) {
        if (line < 0 || line >= $this$getLineText.getLineCount()) {
            return "";
        }
        int start = $this$getLineText.getLineStartOffset(line);
        int end = $this$getLineText.getLineEndOffset(line);
        String string = $this$getLineText.getText(new TextRange(start, end));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final String indentUnit(CommonCodeStyleSettings.IndentOptions options) {
        return options.USE_TAB_CHARACTER ? "\t" : StringsKt.repeat((CharSequence)" ", (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1));
    }

    private final String indentOfLine(Document doc, int line) {
        String string;
        block5: {
            int i;
            char it;
            int index$iv;
            int n;
            String s;
            block4: {
                int n2;
                s = this.getLineText(doc, line);
                CharSequence $this$indexOfFirst$iv = s;
                boolean $i$f$indexOfFirst = false;
                n = $this$indexOfFirst$iv.length();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    n2 = index$iv;
                    break block4;
                }
                n2 = i = -1;
            }
            if (i <= 0) {
                String $this$takeWhile$iv = s;
                boolean $i$f$takeWhile = false;
                n = $this$takeWhile$iv.length();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it == ' ' || it == '\t') continue;
                    String string2 = $this$takeWhile$iv;
                    int n3 = 0;
                    String string3 = string2.substring(n3, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block5;
                }
                string = $this$takeWhile$iv;
            } else {
                String string4 = s.substring(0, i);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
        }
        return string;
    }

    private final int countIndentUnits(String indent, CommonCodeStyleSettings.IndentOptions options) {
        if (((CharSequence)indent).length() == 0) {
            return 0;
        }
        if (options.USE_TAB_CHARACTER) {
            CharSequence $this$count$iv = indent;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == '\t')) continue;
                ++count$iv;
            }
            return count$iv;
        }
        int size = RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1);
        int spaces = 0;
        int n = indent.length();
        for (int i = 0; i < n; ++i) {
            char ch = indent.charAt(i);
            spaces += ch == '\t' ? size : 1;
        }
        return spaces / size;
    }

    private final String computeDesiredIndentFromCore(Document doc, int line, CommonCodeStyleSettings.IndentOptions options) {
        int n;
        String lastLine;
        block3: {
            String string;
            int start = 0;
            int end = doc.getLineEndOffset(line);
            String string2 = doc.getText(new TextRange(start, end));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String snippet = string2;
            boolean isBlankLine = ((CharSequence)((Object)StringsKt.trim((CharSequence)this.getLineText(doc, line))).toString()).length() == 0;
            Object snippetForCalc = isBlankLine ? snippet + "x" : snippet;
            LyngFormatConfig cfg = new LyngFormatConfig(RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1), options.USE_TAB_CHARACTER, RangesKt.coerceAtLeast((int)options.CONTINUATION_INDENT_SIZE, (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1)), 0, false, false, false, 120, null);
            String formatted = LyngFormatter.INSTANCE.reindent((String)snippetForCalc, cfg);
            int lastNl = StringsKt.lastIndexOf$default((CharSequence)formatted, (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (lastNl >= 0) {
                String string3 = formatted.substring(lastNl + 1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = formatted;
            }
            lastLine = string;
            CharSequence $this$indexOfFirst$iv = lastLine;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != ' ' && it != '\t')) continue;
                n = index$iv;
                break block3;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        int wsLen = it < 0 ? lastLine.length() : it;
        String string = lastLine.substring(0, wsLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

