/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.format;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.sergeych.lyng.format.LyngFormatConfig;
import net.sergeych.lyng.format.LyngFormatter;
import net.sergeych.lyng.idea.LyngLanguage;
import net.sergeych.lyng.idea.settings.LyngFormatterSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lnet/sergeych/lyng/idea/format/LyngPreFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PreFormatProcessor;", "<init>", "()V", "process", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/lang/ASTNode;", "range", "lyng-idea"})
public final class LyngPreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        PsiElement psiElement = element.getPsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return range;
        }
        PsiElement file = psiElement;
        if (!Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)LyngLanguage.INSTANCE))) {
            return range;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return range;
        }
        Document doc = document;
        PsiDocumentManager psiDoc = PsiDocumentManager.getInstance((Project)project2);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((Project)project2, (Document)doc);
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions options = indentOptions;
        LyngFormatterSettings settings = LyngFormatterSettings.Companion.getInstance(project2);
        boolean runFullFileIndent = !settings.getEnableSpacing() && !settings.getEnableWrapping();
        boolean modified = false;
        TextRange textRange2 = range.intersection(LyngPreFormatProcessor.process$fullRange(doc));
        if (textRange2 == null) {
            textRange2 = LyngPreFormatProcessor.process$fullRange(doc);
        }
        TextRange workingRange = textRange2;
        int startLine = runFullFileIndent ? 0 : doc.getLineNumber(workingRange.getStartOffset());
        int endLine = runFullFileIndent ? RangesKt.coerceAtLeast((int)(doc.getLineCount() - 1), (int)0) : doc.getLineNumber(RangesKt.coerceAtMost((int)workingRange.getEndOffset(), (int)doc.getTextLength()));
        int blockLevel = 0;
        int parenBalance = 0;
        int bracketBalance = 0;
        for (int ln = 0; ln < startLine; ++ln) {
            String text;
            Intrinsics.checkNotNullExpressionValue((Object)doc.getText(new TextRange(doc.getLineStartOffset(ln), doc.getLineEndOffset(ln))), (String)"getText(...)");
            String string = LyngPreFormatProcessor.process$codePart(text);
            int n = string.length();
            block17: for (int i = 0; i < n; ++i) {
                char ch = string.charAt(i);
                switch (ch) {
                    case '{': {
                        ++blockLevel;
                        continue block17;
                    }
                    case '}': {
                        if (blockLevel <= 0) continue block17;
                        --blockLevel;
                        continue block17;
                    }
                    case '(': {
                        ++parenBalance;
                        continue block17;
                    }
                    case ')': {
                        if (parenBalance <= 0) continue block17;
                        --parenBalance;
                        continue block17;
                    }
                    case '[': {
                        ++bracketBalance;
                        continue block17;
                    }
                    case ']': {
                        if (bracketBalance <= 0) continue block17;
                        --bracketBalance;
                    }
                }
            }
        }
        int line = startLine;
        if (line <= endLine) {
            while (true) {
                String text;
                int lineStart = doc.getLineStartOffset(line);
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent((PsiFile)file, lineStart);
                int lineEnd = doc.getLineEndOffset(line);
                Intrinsics.checkNotNullExpressionValue((Object)doc.getText(new TextRange(lineStart, lineEnd)), (String)"getText(...)");
                String code = LyngPreFormatProcessor.process$codePart(text);
                int n = code.length();
                block19: for (int i = 0; i < n; ++i) {
                    char ch = code.charAt(i);
                    switch (ch) {
                        case '{': {
                            ++blockLevel;
                            continue block19;
                        }
                        case '}': {
                            if (blockLevel <= 0) continue block19;
                            --blockLevel;
                            continue block19;
                        }
                        case '(': {
                            ++parenBalance;
                            continue block19;
                        }
                        case ')': {
                            if (parenBalance <= 0) continue block19;
                            --parenBalance;
                            continue block19;
                        }
                        case '[': {
                            ++bracketBalance;
                            continue block19;
                        }
                        case ']': {
                            if (bracketBalance <= 0) continue block19;
                            --bracketBalance;
                        }
                    }
                }
                if (line == endLine) break;
                ++line;
            }
        }
        if (!settings.getEnableSpacing() && !settings.getEnableWrapping()) {
            TextRange textRange3;
            LyngFormatConfig cfg = new LyngFormatConfig(RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1), options.USE_TAB_CHARACTER, RangesKt.coerceAtLeast((int)options.CONTINUATION_INDENT_SIZE, (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1)), 0, false, false, false, 120, null);
            TextRange full = LyngPreFormatProcessor.process$fullRange(doc);
            if (runFullFileIndent) {
                textRange3 = full;
            } else {
                textRange3 = workingRange.intersection(full);
                if (textRange3 == null) {
                    textRange3 = full;
                }
            }
            TextRange r = textRange3;
            String string = doc.getText(r);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text = string;
            String formatted = LyngFormatter.INSTANCE.reindent(text, cfg);
            if (!Intrinsics.areEqual((Object)formatted, (Object)text)) {
                doc.replaceString(r.getStartOffset(), r.getEndOffset(), (CharSequence)formatted);
                modified = true;
                psiDoc.commitDocument(doc);
                workingRange = LyngPreFormatProcessor.process$fullRange(doc);
            }
        }
        if (settings.getEnableSpacing()) {
            LyngFormatConfig cfg = new LyngFormatConfig(RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1), options.USE_TAB_CHARACTER, RangesKt.coerceAtLeast((int)options.CONTINUATION_INDENT_SIZE, (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1)), 0, true, false, false, 72, null);
            TextRange textRange4 = workingRange.intersection(LyngPreFormatProcessor.process$fullRange(doc));
            if (textRange4 == null) {
                textRange4 = LyngPreFormatProcessor.process$fullRange(doc);
            }
            TextRange safe = textRange4;
            String string = doc.getText(safe);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text = string;
            String formatted = LyngFormatter.INSTANCE.format(text, cfg);
            if (!Intrinsics.areEqual((Object)formatted, (Object)text)) {
                doc.replaceString(safe.getStartOffset(), safe.getEndOffset(), (CharSequence)formatted);
                modified = true;
                psiDoc.commitDocument(doc);
                workingRange = LyngPreFormatProcessor.process$fullRange(doc);
            }
        }
        if (settings.getEnableWrapping()) {
            LyngFormatConfig cfg = new LyngFormatConfig(RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1), options.USE_TAB_CHARACTER, RangesKt.coerceAtLeast((int)options.CONTINUATION_INDENT_SIZE, (int)RangesKt.coerceAtLeast((int)options.INDENT_SIZE, (int)1)), 0, settings.getEnableSpacing(), true, false, 72, null);
            TextRange textRange5 = workingRange.intersection(LyngPreFormatProcessor.process$fullRange(doc));
            if (textRange5 == null) {
                textRange5 = LyngPreFormatProcessor.process$fullRange(doc);
            }
            TextRange safe2 = textRange5;
            String string = doc.getText(safe2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text2 = string;
            String wrapped = LyngFormatter.INSTANCE.format(text2, cfg);
            if (!Intrinsics.areEqual((Object)wrapped, (Object)text2)) {
                doc.replaceString(safe2.getStartOffset(), safe2.getEndOffset(), (CharSequence)wrapped);
                modified = true;
                psiDoc.commitDocument(doc);
                workingRange = LyngPreFormatProcessor.process$fullRange(doc);
            }
        }
        if (modified) {
            textRange = LyngPreFormatProcessor.process$fullRange(doc);
        } else {
            textRange = range.intersection(LyngPreFormatProcessor.process$fullRange(doc));
            if (textRange == null) {
                textRange = LyngPreFormatProcessor.process$fullRange(doc);
            }
        }
        return textRange;
    }

    private static final TextRange process$fullRange(Document doc) {
        return new TextRange(0, doc.getTextLength());
    }

    private static final String process$codePart(String s) {
        String string;
        int idx = StringsKt.indexOf$default((CharSequence)s, (String)"//", (int)0, (boolean)false, (int)6, null);
        if (idx >= 0) {
            String string2 = s.substring(0, idx);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = s;
        }
        return string;
    }
}

