/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.highlight;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.sergeych.lyng.idea.highlight.LyngTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u001b*\u00020\u001cH\u0002J\f\u0010\u001e\u001a\u00020\u001b*\u00020\u001cH\u0002J\f\u0010\u001f\u001a\u00020\u001b*\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/sergeych/lyng/idea/highlight/LyngLexer;", "Lcom/intellij/lexer/LexerBase;", "<init>", "()V", "buffer", "", "startOffset", "", "endOffset", "myTokenStart", "myTokenEnd", "myTokenType", "Lcom/intellij/psi/tree/IElementType;", "keywords", "", "", "start", "", "initialState", "getState", "getTokenType", "getTokenStart", "getTokenEnd", "getBufferSequence", "getBufferEnd", "advance", "isWhitespace", "", "", "isDigit", "isIdentifierStart", "isIdentifierPart", "isPunct", "c", "lyng-idea"})
public final class LyngLexer
extends LexerBase {
    @NotNull
    private CharSequence buffer = "";
    private int startOffset;
    private int endOffset;
    private int myTokenStart;
    private int myTokenEnd;
    @Nullable
    private IElementType myTokenType;
    @NotNull
    private final Set<String> keywords;

    public LyngLexer() {
        Object[] objectArray = new String[]{"fun", "val", "var", "class", "type", "import", "as", "if", "else", "for", "while", "return", "true", "false", "null", "when", "in", "is", "break", "continue", "try", "catch", "finally"};
        this.keywords = SetsKt.setOf((Object[])objectArray);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.myTokenStart = startOffset;
        this.myTokenEnd = startOffset;
        this.myTokenType = null;
        this.advance();
    }

    public int getState() {
        return 0;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.buffer;
    }

    public int getBufferEnd() {
        return this.endOffset;
    }

    public void advance() {
        int i;
        if (this.myTokenEnd >= this.endOffset) {
            this.myTokenType = null;
            return;
        }
        this.myTokenStart = i = this.myTokenEnd == 0 ? this.startOffset : this.myTokenEnd;
        if (i >= this.endOffset) {
            this.myTokenType = null;
            return;
        }
        char ch = this.buffer.charAt(i);
        if (this.isWhitespace(ch)) {
            ++i;
            while (i < this.endOffset && this.isWhitespace(this.buffer.charAt(i))) {
                ++i;
            }
            this.myTokenEnd = i;
            this.myTokenType = LyngTokenTypes.INSTANCE.getWHITESPACE();
            return;
        }
        if (ch == '/' && i + 1 < this.endOffset && this.buffer.charAt(i + 1) == '/') {
            i += 2;
            while (i < this.endOffset && this.buffer.charAt(i) != '\n' && this.buffer.charAt(i) != '\r') {
                ++i;
            }
            this.myTokenEnd = i;
            this.myTokenType = LyngTokenTypes.INSTANCE.getLINE_COMMENT();
            return;
        }
        if (ch == '/' && i + 1 < this.endOffset && this.buffer.charAt(i + 1) == '*') {
            i += 2;
            while (i + 1 < this.endOffset && (this.buffer.charAt(i) != '*' || this.buffer.charAt(i + 1) != '/')) {
                ++i;
            }
            if (i + 1 < this.endOffset) {
                i += 2;
            }
            this.myTokenEnd = i;
            this.myTokenType = LyngTokenTypes.INSTANCE.getBLOCK_COMMENT();
            return;
        }
        if (ch == '\"') {
            ++i;
            while (i < this.endOffset) {
                char c = this.buffer.charAt(i);
                if (c == '\\') {
                    i += 2;
                    continue;
                }
                if (c == '\"') {
                    ++i;
                    break;
                }
                ++i;
            }
            this.myTokenEnd = i;
            this.myTokenType = LyngTokenTypes.INSTANCE.getSTRING();
            return;
        }
        if (this.isDigit(ch)) {
            ++i;
            boolean hasDot = false;
            while (i < this.endOffset) {
                char c = this.buffer.charAt(i);
                if (this.isDigit(c)) {
                    ++i;
                    continue;
                }
                if (c != '.' || hasDot) break;
                hasDot = true;
                ++i;
            }
            this.myTokenEnd = i;
            this.myTokenType = LyngTokenTypes.INSTANCE.getNUMBER();
            return;
        }
        if (this.isIdentifierStart(ch)) {
            ++i;
            while (i < this.endOffset && this.isIdentifierPart(this.buffer.charAt(i))) {
                ++i;
            }
            this.myTokenEnd = i;
            String text = ((Object)this.buffer.subSequence(this.myTokenStart, this.myTokenEnd)).toString();
            this.myTokenType = this.keywords.contains(text) ? (IElementType)LyngTokenTypes.INSTANCE.getKEYWORD() : (IElementType)LyngTokenTypes.INSTANCE.getIDENTIFIER();
            return;
        }
        if (this.isPunct(ch)) {
            this.myTokenEnd = ++i;
            this.myTokenType = LyngTokenTypes.INSTANCE.getPUNCT();
            return;
        }
        this.myTokenEnd = i + 1;
        this.myTokenType = LyngTokenTypes.INSTANCE.getBAD_CHAR();
    }

    private final boolean isWhitespace(char $this$isWhitespace) {
        return $this$isWhitespace == ' ' || $this$isWhitespace == '\t' || $this$isWhitespace == '\n' || $this$isWhitespace == '\r' || $this$isWhitespace == '\f';
    }

    private final boolean isDigit(char $this$isDigit) {
        return '0' <= $this$isDigit ? $this$isDigit < ':' : false;
    }

    private final boolean isIdentifierStart(char $this$isIdentifierStart) {
        return $this$isIdentifierStart == '_' || Character.isLetter($this$isIdentifierStart);
    }

    private final boolean isIdentifierPart(char $this$isIdentifierPart) {
        return this.isIdentifierStart($this$isIdentifierPart) || this.isDigit($this$isIdentifierPart);
    }

    private final boolean isPunct(char c) {
        Object[] objectArray = new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('='), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('^'), Character.valueOf('~')};
        return SetsKt.setOf((Object[])objectArray).contains(Character.valueOf(c));
    }
}

