/*
 * Decompiled with CFR 0.152.
 */
package net.sergeych.lyng.idea.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.sergeych.lyng.idea.settings.LyngFormatterSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/sergeych/lyng/idea/settings/LyngFormatterSettingsConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "panel", "Ljavax/swing/JPanel;", "spacingCb", "Ljavax/swing/JCheckBox;", "wrappingCb", "reindentClosedBlockCb", "reindentPasteCb", "normalizeBlockCommentIndentCb", "getDisplayName", "", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "apply", "", "reset", "lyng-idea"})
public final class LyngFormatterSettingsConfigurable
implements Configurable {
    @NotNull
    private final Project project;
    @Nullable
    private JPanel panel;
    @Nullable
    private JCheckBox spacingCb;
    @Nullable
    private JCheckBox wrappingCb;
    @Nullable
    private JCheckBox reindentClosedBlockCb;
    @Nullable
    private JCheckBox reindentPasteCb;
    @Nullable
    private JCheckBox normalizeBlockCommentIndentCb;

    public LyngFormatterSettingsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public String getDisplayName() {
        return "Lyng Formatter";
    }

    @NotNull
    public JComponent createComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.spacingCb = new JCheckBox("Enable spacing normalization (commas/operators/colons/keyword parens)");
        this.wrappingCb = new JCheckBox("Enable line wrapping (120 cols) [experimental]");
        this.reindentClosedBlockCb = new JCheckBox("Reindent enclosed block on Enter after '}'");
        this.reindentPasteCb = new JCheckBox("Reindent pasted blocks (align pasted code to current indent)");
        this.normalizeBlockCommentIndentCb = new JCheckBox("Normalize block comment indentation [experimental]");
        JCheckBox jCheckBox = this.spacingCb;
        if (jCheckBox != null) {
            jCheckBox.setToolTipText("Applies minimal, safe spacing (e.g., around commas/operators, control-flow parens).");
        }
        JCheckBox jCheckBox2 = this.wrappingCb;
        if (jCheckBox2 != null) {
            jCheckBox2.setToolTipText("Experimental: wrap long argument lists to keep lines under ~120 columns.");
        }
        JCheckBox jCheckBox3 = this.reindentClosedBlockCb;
        if (jCheckBox3 != null) {
            jCheckBox3.setToolTipText("On Enter after a closing '}', reindent the just-closed {\u2026} block using formatter rules.");
        }
        JCheckBox jCheckBox4 = this.reindentPasteCb;
        if (jCheckBox4 != null) {
            jCheckBox4.setToolTipText("When caret is in leading whitespace, reindent the pasted text and align it to the caret's indent.");
        }
        JCheckBox jCheckBox5 = this.normalizeBlockCommentIndentCb;
        if (jCheckBox5 != null) {
            jCheckBox5.setToolTipText("Experimental: normalize indentation inside /* \u2026 */ comments (code is not modified).");
        }
        p.add(this.spacingCb);
        p.add(this.wrappingCb);
        p.add(this.reindentClosedBlockCb);
        p.add(this.reindentPasteCb);
        p.add(this.normalizeBlockCommentIndentCb);
        this.panel = p;
        this.reset();
        return p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        LyngFormatterSettings s = LyngFormatterSettings.Companion.getInstance(this.project);
        JCheckBox jCheckBox = this.spacingCb;
        if (jCheckBox == null) return true;
        if (jCheckBox.isSelected() != s.getEnableSpacing()) return true;
        boolean bl = true;
        if (!bl) return true;
        JCheckBox jCheckBox2 = this.wrappingCb;
        if (jCheckBox2 == null) return true;
        if (jCheckBox2.isSelected() != s.getEnableWrapping()) return true;
        boolean bl2 = true;
        if (!bl2) return true;
        JCheckBox jCheckBox3 = this.reindentClosedBlockCb;
        if (jCheckBox3 == null) return true;
        if (jCheckBox3.isSelected() != s.getReindentClosedBlockOnEnter()) return true;
        boolean bl3 = true;
        if (!bl3) return true;
        JCheckBox jCheckBox4 = this.reindentPasteCb;
        if (jCheckBox4 == null) return true;
        if (jCheckBox4.isSelected() != s.getReindentPastedBlocks()) return true;
        boolean bl4 = true;
        if (!bl4) return true;
        JCheckBox jCheckBox5 = this.normalizeBlockCommentIndentCb;
        if (jCheckBox5 == null) return true;
        if (jCheckBox5.isSelected() != s.getNormalizeBlockCommentIndent()) return true;
        return false;
    }

    public void apply() {
        LyngFormatterSettings s = LyngFormatterSettings.Companion.getInstance(this.project);
        JCheckBox jCheckBox = this.spacingCb;
        s.setEnableSpacing(jCheckBox != null ? jCheckBox.isSelected() : false);
        JCheckBox jCheckBox2 = this.wrappingCb;
        s.setEnableWrapping(jCheckBox2 != null ? jCheckBox2.isSelected() : false);
        JCheckBox jCheckBox3 = this.reindentClosedBlockCb;
        s.setReindentClosedBlockOnEnter(jCheckBox3 != null ? jCheckBox3.isSelected() : false);
        JCheckBox jCheckBox4 = this.reindentPasteCb;
        s.setReindentPastedBlocks(jCheckBox4 != null ? jCheckBox4.isSelected() : false);
        JCheckBox jCheckBox5 = this.normalizeBlockCommentIndentCb;
        s.setNormalizeBlockCommentIndent(jCheckBox5 != null ? jCheckBox5.isSelected() : false);
    }

    public void reset() {
        block4: {
            LyngFormatterSettings s = LyngFormatterSettings.Companion.getInstance(this.project);
            JCheckBox jCheckBox = this.spacingCb;
            if (jCheckBox != null) {
                jCheckBox.setSelected(s.getEnableSpacing());
            }
            JCheckBox jCheckBox2 = this.wrappingCb;
            if (jCheckBox2 != null) {
                jCheckBox2.setSelected(s.getEnableWrapping());
            }
            JCheckBox jCheckBox3 = this.reindentClosedBlockCb;
            if (jCheckBox3 != null) {
                jCheckBox3.setSelected(s.getReindentClosedBlockOnEnter());
            }
            JCheckBox jCheckBox4 = this.reindentPasteCb;
            if (jCheckBox4 != null) {
                jCheckBox4.setSelected(s.getReindentPastedBlocks());
            }
            JCheckBox jCheckBox5 = this.normalizeBlockCommentIndentCb;
            if (jCheckBox5 == null) break block4;
            jCheckBox5.setSelected(s.getNormalizeBlockCommentIndent());
        }
    }
}

